---
title: Azure
---
## Microsoft Azure

Microsoft Azure is Microsoft’s public cloud offering that enables individuals and organizations to create, deploy, and operate cloud-based applications and infrastructure services. The Microsoft Azure public cloud platform offers IaaS, PaaS, and SaaS services to organizations worldwide and supports many different programming languages, tools and frameworks, including both Microsoft-specific and third-party software and systems. Prior to being renamed Microsoft Azure on March 25, 2014, it was called Windows Azure.

Microsoft Azure can also be used in conjunction with various Microsoft solutions, such as Microsoft System Center, and can be leveraged together to extend an organization's current data center into a hybrid cloud that expands capacity and provides capabilities beyond what could be delivered solely from an on-premises standpoint.

### Uses for Microsoft Azure

Microsoft Azure offers many services and resource offerings.
For example, you can use the Azure Virtual Machines compute services to build a network of virtual servers to host an application, database, or custom solution, which would be an IaaS based offering.

Other services can be categorized as PaaS because you can use them without maintaining the underlying operating systems.
For example, when you run a website in Azure Web Apps, or a SQL database in Azure SQL Databases it is not necessary to ensure that you are using the latest version of Internet Information Services (IIS) or SQL and have the latest patches and updates installed, as this is the responsibility of the Microsoft Azure platform.

An example of a SaaS service on Microsoft Azure would be Operations Management Suite, which is set up and accessed via Operational Insights services. Here, you just set up your management tools and connect into the services you wish to manage all through Microsoft Azure, so no local infrastructure is required or needed to be managed. 

### Environments

Azure provides a wealth of different environment types across the board including OS platforms such as Windows Server and Ubuntu Server, there are a number of variants that can be chosen such as Ubuntu 14.04 or Ubuntu 16.10, with the ability to use said environments either via the built-in Azure Web CLI or SSH access via your preferred client.

There are varying levels of machine 'sizes' to choose from, ranging from simple barebone low spec machines all the way up multi-GPU and multi-CPU based heavy hitting boxes.

### Cloud Services - Many services offer free tiers for up to 12 months

* Virtual Machines
* Web apps
* Cosmos DB (NoSQL)
* IOT Hub (Quickly and easily fire up an environment to test your IOT project)
* DevOps Projects (Multiple options to quickly get up and running with a CI/CD project)
* AKS (Azure Kubernetes Service)

Link of all current Azure services - https://azure.microsoft.com/en-us/services/

#### Training Courses

* <a href='https://academy.techcommunity.microsoft.com/pathways/learningpath/d157520a-7541-4bda-bf79-42a12a0cc621' target='_blank' rel='nofollow'>Microsoft Ignite 2017: Cloud App Development on Azure - Intermediate</a>
* <a href='https://academy.techcommunity.microsoft.com/pathways/learningpath/d1fd2f77-00b8-4674-a994-3cb38c85b723' target='_blank' rel='nofollow'>Microsoft Ignite 2017: Open Source on Azure – Intermediate</a>

#### More Information:
* <a href='https://en.wikipedia.org/wiki/Microsoft_Azure' target='_blank' rel='nofollow'>Wikipedia</a>
* <a href='https://azure.microsoft.com/en-us/' target='_blank' rel='nofollow'>Microsoft Azure</a>
* <a href='https://docs.microsoft.com/en-us/learn/' target='_blank' rel='nofollow'>Microsoft Learn</a>

### Video Tutorials
- [Microsoft Azure Tutorials for Beginners](https://www.youtube.com/watch?v=0bPJPiX89K0)
- [Cloud Computing for Beginners](https://www.youtube.com/watch?v=kQnNd-DyrpA)
