---
title: Google Cloud Platform
---
## Google Cloud Platform

Google Cloud Platform (GCP), offered by Google, is a suite of cloud computing services that runs on the same infrastructure that Google uses internally for its end-user products, such as Google Search and YouTube. Alongside a set of management tools,
GCP provides a series of modular cloud services including computing, data storage, data analytics and machine learning.

Some famous web services include:

* Google Compute Engine – IaaS providing virtual machines.
* Google App Engine – PaaS for application hosting.
* Bigtable – IaaS massively scalable NoSQL database.
* BigQuery – SaaS large scale database analytics.
* Google Cloud Functions – FaaS providing serverless functions to be triggered by cloud events.
* Google Cloud Datastore - DBaaS providing a document-oriented database.
* Cloud Pub/Sub - a service for publishing and subscribing to data streams and messages. Applications can communicate via Pub/Sub, without direct integration between the applications themselves.
* Google Cloud Storage - IaaS providing RESTful online file and object storage. It consists of both structured and unstructured data.
* Cloud SQL - IaaS that Provides relational database management system in Postgre and MySQL.
* Google Cloud Dataproc - Managed Apache Spark and Apache Hadoop service.
* BigQuery  - A fully managed, highly scalable data warehouse with built-in ML.
* Cloud AutoML  - Easily train high-quality, custom ML models.
* Knative  - Components to create modern, Kubernetes-native cloud-based software.



#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
* <a href='https://cloud.google.com/docs/' target='_blank' rel='nofollow'>Google Cloud Platform Documentation</a>
* <a href='https://en.wikipedia.org/wiki/Google_Cloud_Platform' target='_blank' rel='nofollow'>Wikipedia</a>
* <a href= 'https://landing.google.com/sre/book.html' target='_blank' rel='nofollow'>Google Site Reliability Engineering</a> 
* <a href= 'https://cloud.google.com/products/' target='_blank' rel='nofollow'>Google Cloud Products</a>
