---
title: Internet Applications
---
## Internet Applications

![Technology layers](https://upload.wikimedia.org/wikipedia/commons/9/9f/Linux_kernel_and_Computer_layers.png)

### Overview

Internet Applications are applications that are enabled by connecting a local device to a remote application server or cloud services.
Internet applications run on desktops and thin clients such as smart devices and other internet appliances.
Desktops commonly use web browsers to facilitate a connection.
Smart devices use either a web browser or a dedicated 'app' or Rich Internet Application.
Web applications are a kind of internet application.

### Full Stack

Internet applications consist of a full stack of layers.
The stack is sometimes divided into two parts or layers: The Front End and the Back End.
However the stack is divided, an application consists of software unique to itself, and a bunch of dependent software.
Dependent software consists of libraries and other software that provide services.

### Full Stack as system of subsystems

A useful way to view each component is as a part of a system of subsystems, where each subsystem is a system of subsystems.
As an analogy, the human body is a system of subsystems.
The body has an immune subsystem, a digestive subsystem, a nervous subsystem, a skeletal subsystem, a muscular subsystem and the like.
The digestive system includes the liver subsystem aka "liver" for example.
Each subsystem is a system in its own area of activity or function.

### Front End of Stack

The 'Front End' is the software unique to the application that performs work on a local device.
A local device has all the functional components of a computer.  software applications installed in an operating system running on hardware (or virtual hardware running on hardware or other virtual hardware.)

### Back end of Stack

The 'Back End' is the software unique to the application that performs work on a remote server.
A remote server has all the functional components of a computer: software applications installed in an operating system running on hardware (or virtual hardware running on hardware or other virtual hardware.)

### Application Bias to Front or Back End

Applications seeking to work consistently across devices or requiring security in data storage and access will tend to have most business logic in the back end.
This is because software at the Front End is subject to many more modes of attack from malicious agents such as viruses, malware, and insider threats aka "inside hackers".
Also, web browsers standardize rendering of web content sent to the Front End.

Applications seeking speed and efficient use of project resources move as much software as possible into the Front End.
By moving resources to the Front End, a project can share its limited Back End resources with more end-users.

### Application Server

An application server or software framework provides the core required dependencies for an internet application.


### More Information:

[FreeCodeCamp Full Stack Development Certification](https://guide.freecodecamp.org/meta/free-code-camp-full-stack-development-certification)

[Rich Internet Application (Wikipedia.org)](https://en.wikipedia.org/wiki/Rich_Internet_application)

[Software Framework (Wikipeida.org)](https://en.wikipedia.org/wiki/Software_framework)

[Web Application Framework (Wikipedia.org)](https://en.wikipedia.org/wiki/Web_framework)

[Application Server (Wikipedia.org)](https://en.wikipedia.org/wiki/Application_server)


