---
title: Computational Genomics
---
# Computational Genomics

A new field that specializes in developing new algorithms in order to study the human genome. Also called bioinformatics or computational biology, this field solves problems in healthcare, medicine, life science, etc. using data science, modeling, and a computer science oriented approach. Further specialization in computational genomics deals with proteomics, which deals with proteins, and other computational-based methods for different aspects of biology and chemistry.

This section will focus on the various data structures and algorithms that are used and created for this purpose from suffix arrays to sequence alignment. 

RNA-Seq is a very common phrase used in Computational Genomics, as it is becoming the go-to standard for analysis of biological samples. RNA sequencing is a technique used to discover and profile RNA in terms of its presence, type, structure, and even quantity in a given biological sample.

Typically, publicly available data is used for Computational Genomics, and often the research made in this field is used by both doctors and corporations to make medical decisions regarding patients and technology.

## Books to read

*Introduction to Computational Genomics* by Matthew W. Hahn
- https://www.amazon.com/Introduction-Computational-Genomics-Studies-Approach/dp/0521671914
- ISBN-13: 978-0521671910
A great starter book for beginners 

## Additional Resources
- This blog by astrobiologist [Mike Lee](https://astrobiomike.github.io/) is a good place to start.  
- Bioinformatics tools are commonly designed in R and Python.  Two such projects are the [Bioconductor](https://www.bioconductor.org/) project (written in R) and the [Biopython](https://biopython.org/) project.

