---
title: Cooling Systems
---

Your computer contains many parts that generate heat. Excessive heat can cause your computer to behave erratically or its hardware to fail prematurely. Overclocking, changing the default hardware settings for maximum performance, will also cause components to run hotter. The more you overclock a graphics card, CPU, etc., the hotter the component will run. Cooling systems assure that your computer is stable and extends the life of your investment.

## Case Cooling
Case cooling can be a combination of a well ventilated case and the use of fans to circulate air within the case. Most cases come with at least one fan. This is the minimum configuration. For best results, there should be at least two fans in the case. One as an intake to draw in cold air, while the other as an exhaust to expel hot air. It is important to consider the direction of the fan and whether or not the fan is intaking air or exhausting air. It is typical to place exhaust fans towards the top of the case as hot air rises, and intake fans towards the bottom of the case as cool air sinks. There are many different types of fans and configurations. Cable management also plays a huge part in cooling the system. Bad cable management and tangled wires can disrupt airflow and cause dust to accumulate inside the case.

## Components Cooling
Cooling devices are available for individual parts on the computer. The two most common are coolers for CPUs and GPUs. There are generally two types of component cooling systems: active and passive, although a combined approach is commonly used.

* Passive Systems - Usually consist of a heat sink or a heat conductive metal attached to the component. Passive cooling works by providing a larger surface to absorb and dissipate the heat.
* Active Systems - Add a fan to the heat sink and you are actively removing heat. The cooling fan can be dynamically adjusted to the load of the CPU or graphics card on most motherboards.
* Liquid Cooling - High performance computers can benefit from a liquid cooled system. These types of systems circulate a liquid between the hot components and a cooling radiator.
* Thermal Paste - As an addition to all GPU and CPU cooling, a layer of thermal paste is added between the CPU and the cooler in order to avoid metal on metal contact, this thermal paste is applied as a thin layer which acts in order to disperse and absorb heat in order to avoid damage to the component.

## Environmental Considerations

* Keep it clean - Dust can clog up fans, heat sinks can act as an insulating layer trapping heat. Use compressed air to clean dust from the internal components. Maintenance of liquid cooling systems should be considered as well. Many forms of liquid cooling require regular flushing to keep the tubes clean.
* Make sure to keep the room clean to keep dust and hair out of the fans and cooling systems to keep them functioning properly.
* Case Covers - Contrary to what you read on the internet, keeping the case covers on the computer will aid cooling. Absence of the case covers disrupts air flow and can actually increase the heat inside the case.
* Room ventilation - Place the computer in a neutral location away from the rooms environmental registers. Keep the computer away from room heaters or vents at all times.
* Room placement - Keep the computer away from windows or areas of strong sunlight exposure. Placement in closets can also provide challenges to cooling. The case should be located in a way that allows good airflow. It is recommended to keep the computer away from any carpet-like material, which can easily bring dust into the computer.
* Space around the computer - Locating the computer away from other equipment allows air to flow in and out of the computer. Placement close to other equipment can constrict air flow and increase heat.
* Fan Air-Flow Direction - Notice the direction the computer case's fans blow air. You want cool air coming in and hot air to exhaust out. Keeping cool air coming in helps control the temperature rating inside the case, which may assist in the life span of the hardware.
* Cable Management - Having a rat's nest of cables can disrupt airflow and make your computer run hotter. It is recommended to take some time to cable manage after building a computer, as it can increase the lifespan of your computer in the future. There are various accessories that can help with cable management. Some examples are zip ties, velcro ties and cable sleeves.

## Thermal Paste
Thermal paste is a thermally conductive compound which is used as an interface between the CPU and the heatsink itself. Thermal paste trys to eliminate the amount of air gapes or space inbetween the heatsink and CPU in order to maxamize the amount of heat transfer in between the two.
### Types of Thermal Paste
Thermal paste comes in differnt varieties which have different amounts of thermal conductivity. From least to greatest thermal conductivity, here are the different types of thermal compound: 
* Silicon Carbide
* Zinc Oxide
* Boron nitride
* Aluminum nitride
* Silver
* Diamond

[Wikipedia - Article on computer cooling](https://en.wikipedia.org/wiki/Computer_cooling)
