---
title: Expansion Cards
---
## Expansion Cards

The primary purpose of an expansion card is to provide or expand on features not offered by the motherboard. For example, the original IBM PC did not have on-board graphics or hard drive capability. In that case, a graphics card and an ST-506 hard disk controller card provided graphics capability and hard drive interface respectively. Some single-board computers made no provision for expansion cards, and may only have provided integrated circuit (IC) sockets on the board for limited changes or customization. Since reliable multi-pin connectors are relatively costly, some mass-market systems such as home computers had no expansion slots and instead used a card-edge connector at the edge of the main board, putting the costly matching socket into the cost of the peripheral device.

In the case of expansion of on-board capability, a motherboard may provide a single serial RS232 port or Ethernet port. An expansion card can be installed to offer multiple RS232 ports or multiple and higher bandwidth Ethernet ports. In this case, the motherboard provides basic functionality but the expansion card offers additional or enhanced ports. The most common expansion card used today is the graphics card. 

### Modern example use cases for Expansion Cards
* Graphics Card - (mentioned above) provides additional graphics capabilities for programs that utilize graphics intensive workloads such as 3D rendered games and business applications.  Note that many modern graphics cards support running in tandem with other graphics cards in the same machine, enabling significant gains in graphics performance.
* USB Card - provides additional USB ports of varying connector type sizes and versions (USB2.0. USB3.0, USB-C) to accommodate plug in peripherals and devices to a computer
* RAID Controller Card - provides the ability to utilize RAID configurations with your hard drives, enabling complex disk configurations to meet specific user needs (RAID-1 for redundancy for example)
* Sound Card - if the motherboard doesn't include basic sound capabilities (less common), a sound card can be purchased to add audio capabilities.  Another reason for using a Sound Card are more audio input options (SPDIF & Multichannel Connectors) or additional audio fidelity options that go above and beyond what basic sound capabilities are provided by the motherboard.
* Network Card - an expansion card that has Ethernet ports on it if the motherboard does not have one or if extra ones are needed. There are also wireless network cards that have antennas on them that add Wi-Fi capabilities to a motherboard that wouldn't otherwise have it.
* Legacy connections - Most newer motherboards won't have parallel or serial ports built in. This is where adapters come in. They plug right into your PCI or PCIE slot(where all the other expansion cards go) and give you these connectors right on the back of your PC!
#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
* <a href='https://en.wikipedia.org/wiki/Expansion_card' target='_blank' rel='nofollow'>Expansion Cards - Wikipedia</a>
* <a href='https://www.computerhope.com/jargon/e/expacard.htm'> Expansion Cards - Computer Hope</a>
