---
title: Computer Hardware
---
## Computer Hardware

In this section, we explore the various hardware components of modern computers. 

## Parts of a Personal Computer

### Central Processing Unit
A Central Processing Unit (CPU) is the electronic circuitry within a computer that carries out the instructions of a computer program. It performs the basic arithmetic, logical, control and input/output (I/O) operations specified by the instructions. The two main companies that manufacture CPUs are Intel and AMD. 

![Intel Core i5 - Front](https://upload.wikimedia.org/wikipedia/commons/thumb/8/83/Intel_i5-2500.jpg/247px-Intel_i5-2500.jpg) ![Intel Core i5 - Back](https://upload.wikimedia.org/wikipedia/commons/thumb/9/95/Intel_i5-3330%2C_bottom.jpg/240px-Intel_i5-3330%2C_bottom.jpg)

### Motherboard
The motherboard houses many of the crucial electronic components of a system, such as the central processing unit (CPU), memory and extension cards. It also provides electrical connection between these components and other peripherals so they can communicate.

![Motherboard](https://fthmb.tqn.com/mmTUdCN6UBGIKlkEggGq4fpV-3k=/768x0/filters:no_upscale()/gig-57c732ed3df78c71b60e7aa5.jpg)  

### Expansion Cards
Expansion cards are printed circuit board that can be inserted into a computer motherboard to add functionality to a computer system via the expansion bus.  It can either add capabilities, like allowing for a new type of I/O port or upgrade existing ones, such as increasing audio quality via sound cards or increasing ethernet speed through a network card. Expansion cards are typically added to the computer by putting them into the motherboard's available PCI-Express slots.
An example of extension cards is the Graphics Processing Unit (GPU). A GPU is a specialized electronic circuit designed to rapidly manipulate and alter memory to accelerate the creation of images in a frame buffer intended for output to a display device.

### Graphics Processing Unit
Modern computers come equipped with either an internal (built-in) or an external GPU. A GPU is similar to a Processor or CPU - it carries out and performs arithmetic, logic, control, and input/output (I/O) operations specified by the instructions.  They are specifically catered towards graphical workloads. It is a CPU dedicated for the graphics-intensive sets of instructions, thus the name GPU.

![Nvidia Titan XP](https://cdn.arstechnica.net/wp-content/uploads/2017/04/nvidia-titan-x.jpg)  

### Storage
A Solid State Drive (SSD) or Hard Disk Drive (HDD) is used to store information on the computer. The drive retains the memory even after the loss of power. A Hard Disk Drive uses a spinning disk to store memory, while a Solid State Drive has no moving mechanical components. Solid State Drives are often used to load operating systems since they are a great deal faster than a traditional Hard Disk Drive. 

![SSD](https://images10.newegg.com/NeweggImage/ProductImage/20-147-373-09.jpg)  
![HDD](https://upload.wikimedia.org/wikipedia/commons/thumb/f/f8/Laptop-hard-drive-exposed.jpg/1280px-Laptop-hard-drive-exposed.jpg) 

### Memory
Random-access memory (RAM) is a form of computer data storage which stores data and machine code currently being used. A random-access memory device allows data items to be read or written in almost the same amount of time irrespective of the physical location of data inside the memory. It does not retain the data after loss of power.

![Ram](https://images10.newegg.com/NeweggImage/ProductImage/20-232-476-S01.jpg)  

### Case
A case is used to house all the components of a computer.  The case helps maintain proper airflow and prevents dust and other foreign substances from getting onto and into the computer and its components. Components housed inside the case are INTERNAL components, while any peripheral components outside the case are known as EXTERNAL components. Computer cases can vary from small and portable to quite large. Some cases are very plain, while others can have lighting effects and unique shapes. 

![Case](https://images-na.ssl-images-amazon.com/images/I/41Wq97Jk20L._SL500_AC_SS350_.jpg)  

### Power Supply Unit
A Power Supply Unit is an electronic device that supplies electric energy to an electrical load. A computer power supply supplies electrical energy to all the components of the computer including: the motherboard, disk drives, and fans. Power supplies vary in the amount of output they provide and power supplies must be matched to the number of components needing power so they are not overloaded. The PSU changes alternating current from a wall socket to low-voltage direct current to operate the CPU and peripheral devices.

![Power Supply](https://upload.wikimedia.org/wikipedia/commons/thumb/b/b6/SFX_PC-PSU_Delta_IMG_9760.JPG/620px-SFX_PC-PSU_Delta_IMG_9760.JPG)

### Input/Output devices
An Input/Output device (IO device) is any hardware used by a human operator or other systems to communicate with a computer. We feed instructions to the computer via input devices. Keyboard, mouse, and monitor would be the most common example of input devices. 

![I/O Devices](https://www.clasohlson.com/medias/sys_master/9225929949214.jpg)

### Monitor
A computer monitor is an output device which displays information in pictorial form.

![Monitor](https://assets.pcmag.com/media/images/523934-dell-ultrasharp-34-curved-monitor-u3417w.jpg?thumb=y)

### Printer
A Printer is also an output device which prints information on paper and you will get a hard copy of your information.

![Printer](https://tse3.mm.bing.net/th?id=OIP.x182MqnHzLndMBv2unN4HwHaE8&pid=15.1&P=0&w=258&h=173)
