---
title: Motherboard
---
## Motherboard

The motherboard is the connecting layer that allows a computer's components to interact with each other. The motherboard typically has connections for Random Access Memory (RAM), a Hard Disk Drive (HDD), a Graphics Processing Unit (GPU), and a Central Processing Unit (CPU). In desktops, the motherboard is a physical board to which all of these components are connected. However, in laptops, the motherboard typically has some of these components integrated due to space constraints. As a result, laptop parts are often more difficult to replace and service while desktop components can be expanded with cards and upgraded parts since they are not generally intregrated onto the motherboard.

A motherboard provides power and connectivity to the computer's components, and acts as the switchboard for all inter-component communications. If the CPU needs to process information that is stored in RAM, for example, the motherboard provides a connection between the CPU and RAM, called the memory bus, to allow for data access. A motherboard includes buses for expansion cards (including the GPU), RAM, and hard drives.

Motherboards are manufactured by companies such as INTEL, ASUS, ACER, GIGABYTE, IBM, SIMMTRONICS and many more.

## Parts of a Motherboard

If you were to open up your computer and take out the motherboard, you would probably get pretty confused about all the different parts. Depending on the make and model of your computer, it might look something like this.

![Motherboard](https://fthmb.tqn.com/mmTUdCN6UBGIKlkEggGq4fpV-3k=/768x0/filters:no_upscale()/gig-57c732ed3df78c71b60e7aa5.jpg)

To understand how computers work, you don't need to know every single part of the motherboard. However, it is good to know some of the more important parts and how the motherboard connects the various parts of a computer system together. Here are some of the typical parts:

- A CPU socket - the actual CPU is directly soldered onto the socket. Since high speed CPUs generate a lot of heat, there are heat sinks and mounting points for fans right next to the CPU socket.
  - Take note that a CPU socket type must match with the motherboards socket to work. Socket types usually change every few generations and it also varies per label (consumer-grade CPUs, brands, HEDT, server CPUs)
- A power connector to distribute power to the CPU and other components from the power supply.
- Slots for the system's main memory, typically in the form of DRAM chips.
- A chip forms an interface between the CPU, the main memory and other components. On many types of motherboards, this is referred to as the Northbridge. This chip also contains a large heat sink. In recent years, features of the Northbridge have been increasingly integrated into the CPU itself.
- A second chip controls the input and output (I/O) functions. It is not connected directly to the CPU but to the Northbridge. This I/O controller is referred to as the Southbridge. The Northbridge and Southbridge combined are referred to as the chipset.
- Several connectors provide the physical interface between input and output devices and the motherboard. The Southbridge handles these connections.
- Slots for one or more hard drives to store files. The most common types of connections are Integrated Drive Electronics (IDE) and Serial Advanced Technology Attachment (SATA).
- A read-only memory (ROM) chip, which contains the firmware, or startup instructions for the computer system. This was previously a system known as BIOS but has been replaced on more modern machines by UEFI
- A slot for a video or graphics card. There are a number of different types of slots, including the Accelerated Graphics Port (AGP) and Peripheral Component Interconnect Express (PCIe).
Additional slots to connect hardware in the form of Peripheral Component Interconnect (PCI) slots.

## Types of Motherboards

Motherboards come in different sizes, known as form factors. The most common motherboard form factor is ATX. Some of the different types of ATX are micro-ATX (sometimes shown as µATX), mini-ATX, FlexATX, EATX, WATX, nano-ATX, pico-ATX, and mobileATX. There are also a number of other variations.

Additionally there can be even smaller boards like the raspberry pi, which are 65mm by 35mm and have all processing units integrated to the board. There are many others that are even more specific in function, such as an Aurdino board. These are typically limited in I/O, have no expansion slots aside from whatever expansion is offered via USB ports, and some display ports like HDMI or similar variants. These are used for small emulator projects, running small servers, or as an alternative to slim client devices in an office. 

## Different types of motherboards:
- AT Motherboards
The oldest of the main boards, these motherboards were used in earlier 286/386 or 486 computers. The AT means the board consists of advanced technology(AT) power connectors. There are two power connectors of 6 pin each mounted on the AT motherboards. The AT motherboards were available in the early 80’s.

![AT Motherboards](http://www.it4nextgen.com/wp-content/uploads/2016/08/motherboard-486.jpg)

- ATX Motherboards
The ATX motherboards started in 90’s and are still available. The ATX connector on the motherboard consists of a single connector. These boards are used for P2/P3 or P/4 processors.

* Motherboard for P1/P2 processors:

![Motherboard for P1/P2 processors](http://www.it4nextgen.com/wp-content/uploads/2016/08/motherboard-pentium2.jpg)

* Pentium 4 motherboard

![Pentium 4 motherboard](http://www.it4nextgen.com/wp-content/uploads/2016/08/main-board-p4.jpg)

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
* <a href='https://www.computerhope.com/jargon/m/mothboar.htm' target='_blank' rel='nofollow'>Motherboard</a>
* <a href='https://en.wikipedia.org/wiki/Chipset' target='_blank' rel='nofollow'>Chipset (wikipedia)</a>
* <a href='http://www.it4nextgen.com/motherboard-components/'>Motherboard (IT4nextgen)</a>
