---
title: Power Supply
---

# Power Supply

A Power Supply Unit (PSU) regulates the power supply to a computer. It converts AC power into steady low-voltage DC power that the internal components can use. A power supply is required in order for a computer to operate, and its wattage must be matched appropriately to all the components inside the computer. It regulates overheating by controlling the voltage. Depending on the model of power supply, voltage control can either be manual or automatic.

## Description
The PSU typically appears as a metal box, in either the top or bottom posterior portion of a PC case. It has several cables connected off of it to various computer components. These cables can be detachable or integrated, depending on the model of PSU. Typically, its wattage (e.g, 600W) is relative to the size of the PSU, and is an important factor to keep in mind when considering the demand of your machine vs how much space is inside the case.

Like the CPU and RAM, the PSU is a necessary component of the PC because, without it, none of the components will function!

## Modularity
PSUs can be divided into two categories:

### Non-modular
A non-modular PSU is the most common type of PSU, this PSU is un-adaptable with the power ports it provides to the components, it will usually contain:
* A 32pin power supply module for the motherboard
* Any number of SATA power supply modules - these are usually to power hard drives
* One or two PCIe power supply modules, usually for expansion cards such as GPU
* A CPU power supply module

### Modular
Modular power supplies are becoming more common, and are commonly seen amongst the "high end" PSUs. The advantage these have over non-modular power supplies is that they can be expanded to add additional power supply modules.

As with the non-modular supply, you will get:
* A 32 pin power supply module for the motherboard
* a CPU power supply module, this will usually be on the same cable as the motherboard power

The PSU will then have several expansion slots on the back to add additional PCIE power cables and SATA cables for multi GPU or hard drive builds. 

## Standard Cables
With every modern power supply you should have:
- 1x Large cable for motherboard
- 1x Small cable for motherboard, typically powers the CPU
- 1x Small cable to power the GPU
- 2x or more small cables to power hard drives, optical drives, and accessory parts. 

## History 
In the past, power supplies often only had on or off switches and didn't include features such as standby mode. They had a variety of different form factors, which made it much more complicated when determining which to choose. Today, the most common form factor for a power supply is ATX. Having a single common form factor simplifies things greatly when choosing which features would be compatible with a build.

## Safety
Because the power supply unit is the first component between the electric outlet and your other PC parts, they are at the highest risk of damage from power surges or spikes. If your machine is situated in an area where these things are common, it would be wise to invest in a surge protector or similar piece of hardware to prevent that kind of damage. 

The internal parts of a PSU are usually not user serviceable. For your safety, it is wise to never open a power supply unit without proper equipment and/or certifications. If you do encounter an open power supply, do not touch any of the internals, even if it has been unplugged, as power can be stored in them for a long time.

Please do not "cheap out" when buying a power supply, it is one of the most crucial elements when building a PC and can damage your other components if not treated as such. 

## Determining Required Wattage
A great way to make sure your computer has enough power to combine the power requirements for every component then add an additional 50-100W to the total.  This should give you the total Wattage required when purchasing your power supply.

Sites like [PC Part Picker](https://pcpartpicker.com/) allow you to add components to a build and then calculate the minimum power requirements for you!

## Additional Resources
- [HowStuffWorks - How a power supply works](https://computer.howstuffworks.com/power-supply.htm)
- [Wikipedia - Power Supply Unit](https://en.wikipedia.org/wiki/Power_supply_unit_(computer))
