---
title: Computer Science
---
# Computer Science

Computer Science is the study of computers and the concepts that make computers possible. It is a scientific approach to computation and its applications. This includes the study of the structure, expression, and algorithms that underlie the manipulation of data.

Much of computer science was pioneered in the latter half of the 20th century.

Students who are interested in computer science will first learn about both hardware and software. It is important to learn how computers work at a low level of abstraction (machine language) and at a high level of abstraction (modern scripting languages like JavaScript) because it will help individuals understand computer science intuitively. 

In the 21st century, computer science has become a backbone for every technological leap we take forward.

# Computer Science Fields
Computer science is categorized into several fields. The following are among the current established and well-studied fields. Most of the fields are further categorized into subfields.
- <a href="https://en.wikipedia.org/wiki/Theory_of_computation">Theory of Computing</a>
  - Complexity Theory
  - Formal Methods
  - Distributed Algorithms
- <a href="https://en.wikipedia.org/wiki/Computer_security">Security</a>
  - Cryptography<br>
- <a href="https://en.wikipedia.org/wiki/Artificial_intelligence">Artificial Intelligence</a>
  - Data Mining
  - Machine Learning
  - Computer Vision
- <a href="https://en.wikipedia.org/wiki/Software_engineering">Software Engineering</a>
  - Software requirements
  - Software design
  - Software construction
  - Software testing
  - Software maintenance
  - Software configuration management
- <a href="https://en.wikipedia.org/wiki/Data_science">Data Sciences</a>
  - Big Data
- <a href="https://en.wikipedia.org/wiki/Human%E2%80%93computer_interaction">Human Computer Interaction</a>
  - Brain Computer Interface
- Systems
  - [Distributed Systems](https://en.wikipedia.org/wiki/Distributed_computing)
  - [Operating Systems](https://en.wikipedia.org/wiki/Operating_system)
  - [Database Systems](https://en.wikipedia.org/wiki/Database)
- <a href="https://www.studytonight.com/data-structures/introduction-to-data-structures">Algorithms and Data Structures</a>
  - Primitive Data Structures
  - Abstract Data Structures
  - Algorithm: Space Complexity & Time Complexity

#### More Information
* [Visualization of Data Structures](http://www.cs.usfca.edu/~galles/JavascriptVisual/Algorithms.html)
* [Khan Academy](https://www.khanacademy.org/computing/computer-science) : A deep dive into algorithms, cryptography, introductory computing, and much more.
* [CS50](https://cs50.harvard.edu) : A free, introduction to computer science, taught by David J. Malan and staff at Harvard & Yale Universities.
* [Data Structure](https://en.wikipedia.org/wiki/Data_structure) 


