---
title: Asymptotic Notation
---
## Asymptotic Notation

How do we measure the performance value of algorithms?

Consider how time is one of our most valuable resources. In computing, we can measure performance with the amount of time a process takes to complete. If the data processed by two algorithms is the same, we can decide on the best implementation to solve a problem.

We do this by defining the mathematical limits of an algorithm. These are the big-O, big-omega, and big-theta, or the asymptotic notations of an algorithm. On a graph the big-O would be the longest an algorithm could take for any given data set, or the "upper bound". Big-omega is like the opposite of big-O, the "lower bound". That's where the algorithm reaches its top-speed for any data set. Big theta is either the exact performance value of the algorithm, or a useful range between narrow upper and lower bounds.

Some examples:
- "The delivery will be there within your lifetime." (big-O, upper-bound)
- "I can pay you at least one dollar." (big-omega, lower bound)
- "The high today will be 25ºC and the low will be 19ºC." (big-theta, narrow)
- "It's a kilometer walk to the beach." (big-theta, exact)
#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->

- <a href='https://learnxinyminutes.com/docs/asymptotic-notation/' target='_blank' rel='nofollow'>Asymptotic Notation</a>
