---
title: Big Omega Notation
---
## Big Omega Notation

Similar to [big O](https://guide.freecodecamp.org/computer-science/notation/big-o-notation) notation, big Omega(Ω) function is used in computer science to describe the performance or complexity of an algorithm.  

If a running time is Ω(f(n)), then for large enough n, the running time is at least k⋅f(n)  for some constant k. Here's how to think of a running time that is Ω(f(n)):  
<img src="https://s3.amazonaws.com/ka-cs-algorithms/Omega_fn.png" alt="big-omega function"/>  
We say that the running time is "big-Ω of f(n)." We use big-Ω notation for **asymptotic lower bounds**, since it bounds the growth of the running time from below for large enough input sizes.  

### Difference between Big O and Big Ω  
The difference between Big O notation and Big Ω notation is that Big O is used to describe the worst case running time for an algorithm. But, Big Ω notation, on the other hand, is used to describe the best case running time for a given algorithm.



#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
- [Big-Ω (Big-Omega) notation](https://www.khanacademy.org/computing/computer-science/algorithms/asymptotic-notation/a/big-big-omega-notation)
- <a href="http://www.youtube.com/watch?feature=player_embedded&v=OpebHLAf99Y
" target="_blank"><img src="http://img.youtube.com/vi/OpebHLAf99Y/0.jpg" 
alt="MYCODSCHOOL Time complexity analysis" width="240" height="180" border="10" /></a>

