---
title: Ports
---

## Ports
A port is an endpoint of communication for an operating system, in the internet protocol suite. Service names and port numbers are used to distinguish between different services that run over transport protocols such as TCP, UDP, DCCP, and SCTP.
When a computer receives a message from an another source the ports will help in determining which process is expecting that message.

A port is always related to an ip adress of a host and the protocol type of the communication, and thus completes the destination or origination network address of a communication session. There are 65536 available ports in the operating system. A port is identified for each address and protocol by a 16-bit number, commonly known as the port number. For example, an address may be "protocol: TCP, IP address: 1.2.3.4, port number: 80", which may be written 1.2.3.4:80 when the protocol is known from context.
Some port numbers are used by convention to identify specific services, such as:

* 1 - TCP Port Service Multiplexer
* 5 - Remote Job Entry
* 7 - Echo Protocol
* 9 - Stream Control Transmission Protocol
* 11 - Active Users (Systat (protocol)|systat
* 13 - Daytime Protocol
* 17 - QOTD|Quote of the Day
* 18 - Message Send Protocol
* 19 - Character Generator Protocol
* 20 - File Transfer Protocol
* 21 - File Transfer Protocol
* 22 - Secure Shell
* 23 - Telnet
* 25 - Simple Mail Transfer Protocol
* 37 - Time Protocol
* 38 - Route Access Protocol
* 39 - Resource Location Protocol
* 42 - ARPA Host Name Server Protocol|Host Name Server Protocol
* 43 - WHOIS
* 49 - TACACS
* 50 - Remote Mail Checking Protocol
* 51 - Historically used for Interface Message Processor
* 52 - Xerox Network Systems
* 53 - Domain Name System
* 54 - Xerox Network Systems (XNS) Clearinghouse (Name Server).
* 56 - Xerox Network Systems (XNS) Authentication Protocol.
* 57 - Any private terminal access
* 58 - Xerox Network Systems (XNS) Mail.
* 61 - Historically assigned to the NIFTP-Based Mail
* 67 - Bootstrap Protocol
* 68 - Bootstrap Protocol (BOOTP) client, also used by Dynamic Host Configuration Protocol (DHCP)
* 69 - Trivial File Transfer Protocol
* 70 - Gopher (protocol)|Gopher
* 71–74 - NETRJS
* 75 - Any private dial out service
* 77 - Any private Remote job entry
* 79 - Finger protocol
* 80 - Hypertext Transfer Protocol
* 87 - Any private terminal link
* 88 - Kerberos (protocol)|Kerberos
* 90 - dnsix (United States Department of Defense|DoD
* 101 - History of the Internet NIC, InterNIC, IANA and ICANN|NIC
* 102 - International Organization for Standardization|ISO
* 104 - Digital Imaging and Communications in Medicine
* 105 - CCSO Nameserver
* 107 - Rtelnet|Remote User Telnet Service
* 108 - IBM Systems Network Architecture
* 109 - Post Office Protocol
* 110 - Post Office Protocol, version 3
* 111 - Open Network Computing Remote Procedure Call
* 113 - Ident protocol|Ident
* 113 - Authentication Service (auth)
* 115 - Simple File Transfer Protocol
* 117 - UUCP Mapping Project
* 118 - Structured Query Language (SQL
* 119 - Network News Transfer Protocol
* 123 - Network Time Protocol
* 126 - Formerly Unisys
* 135 - Distributed Computing Environment|DCE
* 135 - Microsoft
* 137 - NetBIOS
* 138 - NetBIOS Datagram Service
* 139 - NetBIOS Session Service
* 143 - Internet Message Access Protocol
* 152 - Background File Transfer Program
* 153 - Simple Gateway Monitoring Protocol
* 156 - Structured Query Language (SQL
* 158 - Distributed Mail System Protocol
* 161 - Simple Network Management Protocol
* 162 - Simple Network Management Protocol
* 170 - Print server
* 177 - X Display Manager Control Protocol
* 179 - Border Gateway Protocol
* 194 - Internet Relay Chat
* 199 - SNMP
* 201 - AppleTalk
* 209 - Quick Mail Transfer Protocol
* 210 - ANSI
* 213 - Internetwork Packet Exchange
* 218 - Message posting protocol (MPP)
* 220 - Internet Message Access Protocol
* 259 - Efficient Short Remote Operations (ESRO)
* 262 - Arcisdms
* 264 - Border Gateway Multicast Protocol
* 280 - http-mgmt
* 308 - Novastor Online Backup
* 311 - Mac OS X Server
* 318 - PKIX Time Stamp Protocol
* 319 - Precision Time Protocol
* 320 - Precision Time Protocol
* 350 - Mapping of Airline Traffic over Internet Protocol
* 351 - MATIP type B
* 356 - cloanto-net-1 (used by Cloanto Amiga Explorer and VMs)
* 366 - On-Demand Mail Relay (ODMR)
* 369 - Rpc2portmap
* 370 - codaauth2, Coda authentication server
* 370 - securecast1, outgoing packets to McAfee|NAI
* 371 - ClearCase albd
* 383 - HP data alarm manager
* 384 - A Remote Network Server System
* 387 - AURP (AppleTalk
* 389 - Lightweight Directory Access Protocol
* 399 - Digital Equipment Corporation
* 401 - Uninterruptible power supply
* 427 - Service Location Protocol
* 433 - NNSP, part of Network News Transfer Protocol
* 434 - Mobile IP
* 443 - HTTPS or HTTP over SSL
* 444 - Simple Network Paging Protocol
* 445 - Microsoft-DS (Directory Services) Active Directory
* 445 - Microsoft-DS (Directory Services) Server Message Block|SMB
* 464 - Kerberos (protocol)|Kerberos
* 465 - URL Rendezvous Directory for SSM (Cisco protocol)
* 465 - Authenticated Simple Mail Transfer Protocol|SMTP
* 475 - tcpnethaspsrv, Aladdin Knowledge Systems
* 497 - Retrospect (software)|Retrospect
* 500 - Internet Security Association and Key Management Protocol
* 502 - Modbus
* 504 - Citadel/UX|Citadel
* 510 - FirstClass Protocol (FCP), used by FirstClass
* 512 - Remote Process Execution|Rexec
* 512 - comsat, together with Biff (computing)|biff
* 513 - rlogin
* 513 - Who
* 514 - Remote Shell
* 514 - Syslog
* 515 - Line Printer Daemon protocol|Line Printer Daemon
* 517 - Talk
* 518 - NTalk
* 520 - efs, extended file name server
* 520 - Routing Information Protocol
* 521 - Routing Information Protocol RIPng|Routing Information Protocol Next Generation
* 524 - NetWare Core Protocol
* 525 - Timed, Timeserver
* 530 - Remote procedure call
* 532 - netnews
* 533 - netwall, For Emergency Broadcasts
* 540 - Unix-to-Unix Copy Protocol (UUCP
* 542 - commerce
* 543 - klogin, Kerberos (protocol)|Kerberos
* 544 - kshell, Kerberos (protocol)|Kerberos
* 546 - DHCPv6
* 547 - DHCPv6
* 548 - Apple Filing Protocol
* 550 - new-rwho, new-who
* 554 - Real Time Streaming Protocol
* 556 - Remotefs, Remote File System|RFS
* 560 - rmonitor, Remote Monitor
* 561 - monitor
* 563 - NNTP
* 587 - Mail submission agent|email message submission
* 591 - FileMaker
* 593 - HTTP RPC Ep Map, Remote procedure call
* 601 - Reliable Syslog
* 604 - TUNNEL profile, a protocol for BEEP
* 623 - ASF Remote Management and Control Protocol (ASF-RMCP) & IPMI Remote Management Protocol
* 631 - Internet Printing Protocol
* 635 - RLZ DBase
* 636 - Lightweight Directory Access Protocol
* 639 - MSDP, Multicast Source Discovery Protocol
* 641 - SupportSoft Nexus Remote Command (control/listening), a proxy gateway connecting remote control traffic
* 643 - SANity
* 646 - Label Distribution Protocol
* 647 - Dynamic Host Configuration Protocol Reliability|DHCP Failover
* 648 - Registry Registrar Protocol (RRP)
* 651 - IEEE-MMS
* 653 - SupportSoft Nexus Remote Command (data), a proxy gateway connecting remote control traffic
* 654 - Media Management System (MMS) Media Management Protocol (MMP)
* 655 - Tinc (protocol)|Tinc
* 657 - IBM
* 660 - Mac OS X Server
* 666 - Doom (game)|Doom
* 674 - Application Configuration Access Protocol
* 688 - REALM-RUSD (ApplianceWare Server Appliance Management Protocol)
* 690 - Velneo Application Transfer Protocol (VATP)
* 691 - Microsoft|MS
* 694 - Linux-HA
* 695 - IEEE
* 698 - Optimized Link State Routing protocol|Optimized Link State Routing
* 700 - Extensible Provisioning Protocol
* 701 - Link Management Protocol (LMP), a protocol that runs between a pair of Node (networking)|nodes
* 702 - IRIS (Internet Registry Information Service) over BEEP
* 706 - SILC (protocol)|Secure Internet Live Conferencing
* 711 - Cisco
* 712 - Topology Broadcast based on Reverse-Path Forwarding routing protocol
* 749 - Kerberos (protocol)
* 750 - kerberos-iv, Kerberos (protocol)|Kerberos
* 753 - Reverse Routing Header (RRH)
* 754 - tell send
* 800 - mdbs-daemon
* 829 - Certificate Management Protocol
* 830 - NETCONF
* 831 - NETCONF over BEEP
* 832 - NETCONF for SOAP
* 833 - NETCONF for SOAP over BEEP
* 847 - Dynamic Host Configuration Protocol Reliability|DHCP Failover
* 848 - Group Domain Of Interpretation (GDOI) protocol
* 853 - Domain Name System|DNS
* 860 - iSCSI
* 861 - OWAMP control (RFC 4656)
* 862 - TWAMP control (RFC 5357)
* 873 - rsync
* 953 - BIND
* 989 - FTPS
* 990 - FTPS
* 991 - Netnews
* 992 - Telnet
* 993 - Internet Message Access Protocol
* 995 - Post Office Protocol
* 3389 - Remote Desktop Protocol (RDP)

## Additional Resources
* [iana.org](https://www.iana.org/assignments/service-names-port-numbers/service-names-port-numbers.xhtml)
* [Wikipedia](https://en.wikipedia.org/index.php?q=aHR0cHM6Ly9lbi53aWtpcGVkaWEub3JnL3dpa2kvUG9ydF8oY29tcHV0ZXJfbmV0d29ya2luZyk)
* [Webopedia](https://www.webopedia.com/quick_ref/portnumbers.asp)
