---
title: Quantum Computing
---

## Quantum Computing

Quantum computing studies computation systems (quantum computers) that make direct use of quantum-mechanical phenomena, such as superposition and entanglement, to perform operations on data.

### What is quantum computing?

Nature -- including molecules like caffeine -- follows the laws of quantum mechanics, a branch of physics that explores how the physical world works at the most fundamental levels. At this level, particles behave in strange ways, taking on more than one state at the same time, and interacting with other particles that are very far away. Quantum computing harnesses these quantum phenomena to process information in a novel and promising way.

Quantum Computing is the study of quantum computation systems that make use of quantum mechanical phenomena, such as entanglement and superposition. Classical binary digit electronic computers (like your own PC!) are based on transistors, which stores data in binary digits (bits), each of which can be in one of two states (0 or 1). Quantum computers on the other hand store data into quantum bits (Qubits), which can be in so-called 'superpositions' (that of being simultaneously in all possible positions).

Because a quantum computer is able to take advantage of these quantum mechanical properties, it is theorized that large scale quantum computers will be able to solve certain problems far faster than classical computers.

### What are classical computers?

The computers we use today are known as classical computers. They’ve been a driving force in the world for decades -- advancing everything from healthcare to how we shop. But there are certain problems that classical computers will simply never be able to solve. Consider the caffeine molecule in a cup of coffee. Surprisingly, it’s complex enough that no computer that exists or could be built would be capable of modeling caffeine and fully understanding its detailed structure and properties. This is the type of challenge quantum has the potential to tackle.

### How do quantum computers work? 

Classical computers encode information in bits. Each bit can take the value of 1 or 0. These 1s and 0s act as on/off switches that ultimately drive computer functions. Quantum computers, on the other hand, are based on Qubits, which operate according to two key principles of quantum physics: superposition and entanglement. Superposition means that each qubit can represent both a 1 and a 0 at the same time. Entanglement means that qubits in a superposition can be correlated with each other; that is, the state of one (whether it is a 1 or a 0) can depend on the state of another. Using these two principles, qubits can act as more sophisticated switches, enabling quantum computers to function in ways that allow them to solve difficult problems that are intractable using today’s computers.

### What can quantum computers do?

Quantum systems may untangle the complexity of molecular and chemical interactions leading to the discovery of new medicines and materials. They may enable ultra-efficient logistics and supply chains, such as optimizing fleet operations for deliveries during the holiday season. They may help us find new ways to model financial data and isolate key global risk factors to make better investments. From a database development perspective, this level of processing can handle queries and pull data at levels beyond binary computing's capabilities. And they may make facets of artificial intelligence such as machine learning much more powerful.

### Further Resources

[Quantum Computers Explained – Limits of Human Technology | Kurzgesagt – In a Nutshell](https://www.youtube.com/watch?v=JhHMJCUmq28) 
       
[Quantum computing explained with a deck of cards | Dario Gil, IBM Research](https://www.youtube.com/watch?v=yy6TV9Dntlw)
    
