---
title: Qubits
---

## Qubits

A Qubit is short for quantum bit, analogous to the classical computer's binary digit (bit). It is the basic unit of information in a quantum computer, just like a binary digit (0 or 1) is the basic unit of information in classical computers widely in use today. 

The major difference between the classical bit and the quantum bit has to do with the amount of **states** they can exist in at a time which directly impacts on the amount of information they can hold. In a classical system, a bit would have to be in one state (0) or the other (1) at any one time. However, **quantum mechanics** allows the qubit to behave as if it were in both states simultaneously. In other words, each additional qubit utilized increases exponentially the amount of information the quantum computer can process or hold. This property is fundamental to quantum computing. 

To illustrate this further, if you had one qubit, you can store a "0" and "1" simultaneously (which corresponds to a total of 2 states or values). If you had a 2-qubit system, you can hold **four** values at once - 00, 01, 10, and 11. With a 3-qubit system, you can hold **eight** values at once - 000, 001, 010, 011, 100, 101, 110, and 111. In general, a quantum system consisting of n-qubits will be able to have 2^n states which is exponentially more powerful than any classical computer.

#### More Information:

[Ars Technica - Explanation of Quantum Computing and Qubits](https://arstechnica.com/science/2010/01/a-tale-of-two-qubits-how-quantum-computers-work)

[Wikipedia - Qubits](https://en.wikipedia.org/wiki/Qubit)

[Wikipedia - Quantum Superposition](https://en.wikipedia.org/wiki/Quantum_superposition)

[Quantum Mechanics on Wikipedia](https://en.wikipedia.org/wiki/Quantum_mechanics)
