---
title: CSS Framework Bootstrap
---
# CSS Framework Bootstrap

Bootstrap is the most popular CSS framework for developing responsive, mobile first projects for the web.

## Getting Started - Latest version: 4.1

Below is a simple HTML template which includes the latest compiled and minified CSS and JavaScript for the Bootstrap library. We have used a CDN in this example, please see <a href='https://getbootstrap.com/docs/4.1/getting-started/download/' target='_blank' rel='nofollow'>the official documentation</a> for other ways of installing the latest version of Bootstrap.

```html
    <!DOCTYPE html>
    <html lang="en">
      <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <title>Bootstrap</title>
          
        <!--Latest compiled and minified CSS-->
        <link rel="stylesheet" href="http://192.168.109.2/resources/bootstrap-4.1.2/dist/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
      </head>
      <body>
        <!-- Add all HTML Code below -->
          
        <!-- Add all HTML Code above -->
          
        <!-- jQuery -->
        <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
        <!-- popper.js -->
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49" crossorigin="anonymous"></script>
        <!-- Latest compiled bootstrap JavaScript -->
        <script src="http://192.168.109.2/resources/bootstrap-4.1.2/dist/js/bootstrap.min.js" integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy" crossorigin="anonymous"></script>
      </body>
    </html>
```

## Getting started - Bootstrap 3

Bootstrap 3 isn't the latest stable version of Bootstrap, but it's still the most widely used version. You will find it in a lot of templates, WordPress themes, projects and many more. With that in mind, it's clear it is still useful to know how to use it.
Don't hesitate to go through the excellent <a href="https://getbootstrap.com/docs/3.3/getting-started/" target="_blank" rel="nofollow">Bootstrap Documentation</a>.

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap 3 CSS -->
    <link rel="stylesheet" href="http://192.168.109.2/resources/bootstrap-3.3.7/css/bootstrap.min.css">
  
    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
  </head>
  <body>
    <!-- Add all HTML Code below -->
          
    <!-- Add all HTML Code above -->

    <!-- jQuery library -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>
    <!-- IU jQuery for better animations-->
    <script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
    <!-- compiled JavaScript -->
    <script src="http://192.168.109.2/resources/bootstrap-3.3.7/js/bootstrap.min.js"></script> 
  </body>
</html>
```

<b>Note:</b> Other versions are available and can be found on Bootstrap website.

## Learning Resources

*   Checkout the official Bootstrap 4 Documentation <a href="https://getbootstrap.com/docs/4.1/getting-started/introduction/" target="_blank">here</a>
*   Checkout the official Bootstrap 3 Documentation <a href='https://getbootstrap.com/docs/3.3/getting-started/' target='_blank' rel='nofollow'>here</a>.
*   Checkout Bootstrap's open source GitHub repository <a href='https://github.com/twbs/bootstrap' target='_blank' rel='nofollow'>here</a>.
*   At <a href='https://www.freecodecamp.com/' target='_blank' rel='nofollow'>FreeCodeCamp</a>, we teach Bootstrap as part of our curriculum.
