---
title: CSS Framework Foundation
---
# CSS Framework Foundation

[Foundation](http://foundation.zurb.com/) is an open-source, mobile first CSS framework created by [Zurb](https://zurb.com/).

## Getting Started

Here is a simple HTML template which includes the latest compiled and minified CSS and JavaScript for the Foundation library.

```html
    <!DOCTYPE html>
    <html lang="en">
      <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Foundation Template</title>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/foundation/6.2.1/foundation.min.css">
      </head>
      <body>
        <h1>Hello World</h1>
        <!-- Add all HTML Code here -->
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
        <script src="https://cdn.jsdelivr.net/foundation/6.2.1/foundation.min.js"></script>
      </body>
    </html>
```

This example makes use of a CDN that loads the default settings. (You can always find the latest versions at [cdnjs.com](https://cdnjs.com/libraries/foundation)) If you'd like to customize the grid layout, change the colors or add and remove components you can do so on the Foundation [download](http://foundation.zurb.com/sites/download/) page.

#### Learning Resources

1. [Foundation Documentation](http://foundation.zurb.com/sites/docs/)
1. [List of Foundation Tutorials](https://github.com/zurb/foundation-sites)
1. [Foundation Source Files on GitHub](http://foundation.zurb.com/learn/tutorials.html)
1. [DevTips YouTube Series on Foundation Grid](https://www.youtube.com/playlist?list=PLqGj3iMvMa4LJo_lBMTJwAlQRElulSeL8)
