---
title: CSS Framework Materialize
---
# CSS Framework Materialize

Materialize is a Responsive CSS framework based on Google's <a href='https://design.google.com/spec/' target='_blank' rel='nofollow'>Material Design</a> Language.

## Getting Started

Here is a simple HTML template which includes the latest compiled and minified CSS and JavaScript for the Materialize library.
```html
    <!DOCTYPE html>
  <html>
    <head>
      <!--Import Google Icon Font-->
      <link href="http://192.168.109.2/resources/google-icons/iconfont/material-icons.css" rel="stylesheet">
      <!--Import materialize.css-->
      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/materialize/0.100.2/css/materialize.min.css">

      <!--Let browser know website is optimized for mobile-->
      <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    </head>

    <body>
      <h1>Hello World!</h1>
      <!--Import jQuery before materialize.js-->
      <script type="text/javascript" src="https://code.jquery.com/jquery-3.2.1.min.js"></script>
      <script src="https://cdnjs.cloudflare.com/ajax/libs/materialize/0.100.2/js/materialize.min.js"></script>
    </body>
  </html>
```
We have used a CDN in this example, but you can checkout other ways of installing Materialize <a href='http://materializecss.com/getting-started' target='_blank' rel='nofollow'>here</a>.

## Learning Resources

*   The official documentation for Materialize is available <a href='www.materializecss.com/' target='_blank' rel='nofollow'>here</a>.
*   Checkout Materialize's open source GitHub repository <a href='https://github.com/Dogfalo/materialize' target='_blank' rel='nofollow'>here</a>.
*   <a href='https://scotch.io/tutorials/make-material-design-websites-with-the-materialize-css-framework' target='_blank' rel='nofollow'>Here</a> is a handy tutorial on using Materialize.
