---
title: CSS Frameworks
---

CSS frameworks are designed to simplify the work of the typesetter, eliminate errors when creating a project, and get rid of the boring monotonous writing of the same code.


Advantages of CSS frameworks:

* Cross-browser compatibility
* Ability to create the correct HTML layout even for a not very experienced specialist.
* Code uniformity
* Increase development speed

Minuses:

 * Attachment to CSS style library
 * Redundant code


## Bootstrap

One of the most famous CSS frameworks to date. Includes templates for drawing buttons, sidebars, navigation bars, forms, and other site elements. Includes itself javascript extensions.

Bootstrap is compatible with all major modern browsers, but there may be problems in older versions of browsers. Supports adaptability. Uses the languages Less and Sass.

## Skeleton

Based on JavaScript and CSS, it is used to quickly and accurately create responsive websites that are correctly displayed on both large monitors and small gadget screens. A big plus Skeleton - it can be adapted to any design. The markup grid contains 12 columns and has a base width of 960 pixels. Compatible with all major browsers.

## Kube

Complete freedom for the developer without imposing styles. Provides maximum design flexibility. It has several grid options and is positioned by the creators as a framework for professional CSS developers. Uses Less, supports responsive design.

## Foundation

Common CSS framework. Along with other main elements includes several HTML templates with different arrangement of blocks on the page. It has a large set of components in JavaScript. The framework is very serious in its capabilities and composition. Uses Sass. Compatible code with all major browsers.

## Semantic UI

Support for Firefox, Chrome, Safari, Internet Explorer, Android 4, Blackberry10. Contains a large number of components: icons, images, labels, menus and other standard components. It supports the latest versions of HTML and CSS and has a good selection of script modules and APIs. Uses Less. On applicability competes with bootstrap.

Each task has its own tool. A good step would be to try the framework and understand “your” it or not. You can use the skeletons of the code presented in the frameworks as a cheat sheet and just take solutions and code from there.

## More information
<a href="https://blog.zipboard.co/a-beginners-guide-to-css-front-end-frameworks-8045a499456b">A beginner's guide to CSS frameworks</a>

