---
title: CSS Images
---
## CSS Images
This helps in adding an image to a website. CSS can handle images like JPG, PNG or other raster format. There are two types images: plain images which are sometimes referenced with a url, and dynamically generated images which are generated by some element.

#### Code Sample

```<img src="picture.jpg" alt="Picture" width="100" height="100">```

* **src:** It consists the value of the path to the required image.
* **alt:** This is a text description of the image and is useful if the image cannot be viewed by a visitor. It also allows the image on your page to rank in image search results for search engines such as Google.
* **width:** This specifies a width for the image(can be percent or px or auto).
* **height:** This specifies a height for the image(can be percent or px or auto).

#### CSS Defaults

The `img` element will be rendered by default in most browsers to be displayed as an inline-block display type unless specified otherwise.

```
img {
  display: inline-block;
}
```

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
It is advised to change any one parameter, either height or width, to get a proportionate image. Changing both dimensions results in forced scaling and is not advisable.

**Example:** Both of these will result in a proportionate image
```
<img src="picture.jpg" alt="Picture" width="100">
    
//  or
     
<img src="picture.jpg" alt="Picture" height="100">
```

##### Properties
<a title="The image-orientation CSS property describes how to correct the default orientation of an image." href="/en-US/docs/Web/CSS/image-orientation"><code>image-orientation</code></a>
<a title="The image-rendering CSS property provides a hint to the browser about the algorithm it should use to scale images." href="/en-US/docs/Web/CSS/image-rendering"><code>image-rendering</code></a>
<a title="The object-fit CSS property specifies how a replaced element, such as an <img> or <video>, should be resized to fit its container." href="/en-US/docs/Web/CSS/object-fit"><code>object-fit</code></a>
<a title="The object-position CSS property determines the alignment of the selected element inside its box." href="/en-US/docs/Web/CSS/object-position"><code>object-position</code></a>

##### Functions
<a title="The documentation about this has not yet been written; please consider contributing!" href="/en-US/docs/Web/CSS/linear-gradient"><code>linear-gradient()</code></a>
<a title="The documentation about this has not yet been written; please consider contributing!" href="/en-US/docs/Web/CSS/radial-gradient"><code>radial-gradient()</code></a>
<a title="The documentation about this has not yet been written; please consider contributing!" href="/en-US/docs/Web/CSS/repeating-linear-gradient"><code>repeating-linear-gradient()</code></a>
<a title="The documentation about this has not yet been written; please consider contributing!" href="/en-US/docs/Web/CSS/repeating-radial-gradient"><code>repeating-radial-gradient()</code></a>
<a title="The documentation about this has not yet been written; please consider contributing!" href="/en-US/docs/Web/CSS/element"><code>element()</code></a>

##### Datatypes
<a title="The <image> CSS data type represents a 2D image. There are two kinds of images: plain images, typically referenced using a URL, and dynamically-generated images, like those generated with <gradient> or element(). Images can be used with numerous CSS properties, such as background-image, border-image, content, list-style-image, and cursor." href="/en-US/docs/Web/CSS/image"><code>&lt;image&gt;</code></a>
<a title="The documentation about this has not yet been written; please consider contributing!" href="/en-US/docs/Web/CSS/uri"><code>&lt;uri&gt;</code></a>

##### Image Sprites
An image sprite is a collection of images put into a single image.
A web page with many images can take a long time to load and generates multiple server requests.
Using image sprites will reduce the number of server requests and save bandwidth.

```
#home {
    width: 46px;
    height: 44px;
    background: url(img_navsprites.gif) 0 0;
}
```

#### More Info:
<!-- References for more information on CSS images -->
- [CSS Images, developer mozilla](https://developer.mozilla.org/en-US/docs/Web/CSS/image)     
