---
title: CSS Grid Layout
---
## CSS Grid Layout
CSS Grid Layout is the most powerful layout system available in CSS.
It is a 2-dimensional system, meaning it can handle both columns and rows, unlike flexbox which is largely a 1-dimensional system.
Though Grid Layout isn't fully supported by all browsers, it's the most advanced and convenient way to make page layouts.

One of the real advantages of CSS Grid Layout is being able to design responsive layouts without the use of media queries. CSS Grid works with explicit grids, with defined numbers of rows and columns, or implicit grids, which are automatically generated to contain extra items that are not explicitly defined. This allows a great deal of flexibility in responsive styling using a minimum of CSS code.

### Basic Terminology

#### Grid Container
Element on which `display: grid;` property is applied. Its direct children become grid items.

#### Grid Item
Direct child of the grid container.

#### More Resources:
- [A Complete Guide to CSS Grid Layout](http://chris.house/blog/a-complete-guide-css-grid-layout/)
- [Basic concepts of grid layout](https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Grid_Layout/Basic_Concepts_of_Grid_Layout)
- [Grid by Example](https://gridbyexample.com/)
- [Wes Bos - Free CSS Grid Course](https://cssgrid.io/)
- [YouTube - CSS Grid Playlist](https://www.youtube.com/watch?v=FEnRpy9Xfes&list=PLbSquHt1VCf1x_-1ytlVMT0AMwADlWtc1)
- [Free Code Camp CSS Grid Course](https://www.youtube.com/watch?v=t6CBKf8K_Ac)
- [CSS Grid Garden Exercises](https://cssgridgarden.com) - [Guide](https://github.com/thomaspark/gridgarden).
- [Scrimba - Learn CSS Grid for free - screencast](https://scrimba.com/g/gR8PTE)

More info about browser support can be read at <a href="https://caniuse.com/#feat=css-grid" target="_blank">https://caniuse.com</a>.
