---
title: CSS3 Multiple Columns
---
## CSS3 Multiple Columns

The CSS **multi-column layout** extends the *block layout* mode to allow the easy definition of multiple columns of text. People have trouble reading text if lines are too long; if it takes too long for the eyes to move from the end of the one line to the beginning of the next, they lose track of which line they were on. Therefore, to make maximum use of a large screen, authors should have limited-width columns of text placed side by side, just as newspapers do.

Unfortunately this is impossible to do with CSS and HTML without forcing column breaks at fixed positions, or severely restricting the markup allowed in the text, or using heroic scripting. This limitation is solved by adding new CSS properties to extend the traditional block layout mode.

There are several properties that let you customize multi-column layout:
* column-count
* column-fill
* column-gap
* column-rule-style
* column-rule-width
* column-rule-color
* column-rule
* column-span
* column-width
* columns

<!-- The article goes here, in GitHub-flavored Markdown. Feel free to add YouTube videos, images, and CodePen/JSBin embeds  -->

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
<a href='https://css-tricks.com/almanac/properties/c/columns/' target='_blank' rel='nofollow'>This is a great article</a> to read up to understand more about CSS3 Multiple Columns

