---
title: Cascading Style Sheets (CSS)
---

![CSS Logo](https://upload.wikimedia.org/wikipedia/commons/thumb/d/d5/CSS3_logo_and_wordmark.svg/320px-CSS3_logo_and_wordmark.svg.png)

## Cascading Style Sheets (CSS)
CSS stands for *Cascading Style Sheets*. It is a language used for describing the style of a document written in HTML. It was designed to enable the separation of presentation and content, which greatly improved content accessibility and gave more flexibility and control in the specification of presentation, and reduced complexity and repetition in the structural content. It was first invented in 1996 and is now a standard feature of all major web browsers. The newest version of CSS is CSS3, which builds upon CSS2.1 and adds more visual functionalities, ready for the modern world.

We can describe CSS in three ways:
 1) Internal CSS
 2) External CSS
 3) Inline CSS
 
External CSS files save with extension of .css.

CSS specifications are maintained by the [World Wide Web Consortium (W3C)](https://www.w3.org/).

You can build some pretty amazing things in CSS alone, such as this pure-CSS [Minesweeper game](https://codepen.io/bali_balo/pen/BLJONk) (which uses no JavaScript).
![Minesweeper clone in CSS](https://cdn-images-1.medium.com/max/800/1*GFcKk9KxqHAnWa1ECcKDOQ.png)

### Syntax
`body { background-color: yellow; }` this is the Syntax of a CSS property.  
In here, `body` is the selector and says what HTML element we want to style.
`background-color` is the property we want to style.  
and `yellow` is the style we want to give it.

### Sample Code:
```html
<!DOCTYPE html>
<html>
  <head>
	  <style>
  		body { background-color: Yellow; }
      p { font-size: 18px; } 
	  </style>
  </head>
  
  <body>
	  <p>Welcome to the world of CSS</p>
  </body>
</html>
```
We use the `<style>` and `</style>` tags to define the CSS in the HTML file.

### Popular CSS Frameworks 2018
Frameworks exist to make the more complex parts of CSS easier and more efficient for developers to build out websites.  They also allow the developer to have more flexibility as well as additional features to produce amazing results.
Some of the most popular CSS Frameworks are:
* [Bootstrap](https://getbootstrap.com/)
* [Foundation](https://foundation.zurb.com/sites/docs/v/5.5.3/css.html)
* [Bulma](https://bulma.io/)
* [uikit](https://getuikit.com/)
* [Semantic UI](https://semantic-ui.com/)
* [mini.css](https://minicss.org/)
* [Materialize](https://materializecss.com/)
* [Material Design Lite](https://getmdl.io/)
* [Spectre](https://picturepan2.github.io/spectre/)
* [Kube](https://imperavi.com/kube/)

### Suggested Reading:
* [Introduction to Basic CSS](https://learn.freecodecamp.org/responsive-web-design/basic-css) by freeCodeCamp: a good place to start!
* [Starting with HTML + CSS](https://www.w3.org/Style/Examples/011/firstcss) by W3C: how to create a style sheet - for beginners.
* [CSS Zen Garden](http://www.csszengarden.com/): a great example of how the same HTML can be styled to look totally unique.
* [Jon Duckett's book on HTML and CSS](https://www.amazon.com/HTML-CSS-Design-Build-Websites/dp/1118008189) could be an excellent start for the ones who wish to explore the topic to its great depth with some amazing examples.
* [The Odin Project](https://www.theodinproject.com/courses/html5-and-css3) features a full course on using CSS alongside HTML.
* [Species In Pieces](http://species-in-pieces.com/#): for a demonstration of the power of CSS. 
* [MDN Web Docs for CSS](https://developer.mozilla.org/en-US/docs/Web/CSS) for more resources for developers, BY developers!
* [CSS reference.io](https://cssreference.io/) to help you along the way if you're unsure about a property. A great tool for helping visualize what each CSS property does.
* [CSS-Tricks](https://css-tricks.com) Tips and tricks for working with CSS
* [tutorialspoint](https://www.tutorialspoint.com/css/)
