---
title: Background Color Property
---
## Background Color Property

You use the `background-color` property to set the background color of an element. You can either use a color value (color name, hexadecimal value, RGB/RGBA value, HSL/HSLA value) or the keyword `transparent`.

**Example:**

```css
body {
  background-color: crimson;
}

div {
  background-color: #ffffff;
}

.myClass {
  background-color: rgba(0, 0, 0, 0.5);
}
```

#### Property Values:
`background-color: color | transparent | initial | inherit;`


`color` - Specifies the background color (color name, hexadecimal value, RGB/RGBA value, HSL/HSLA value).

`transparent` - The default value. Sets the background color as transparent.

`initial` - Sets this property to its initial value (the default value).

`inherit` - Inherits this property from its parent element.

#### More Information:
<a href='https://developer.mozilla.org/en-US/docs/Web/CSS/background-color?v=b' target='_blank' rel='nofollow'>MDN web docs</a>
