---
title: Cursor Property
---

## Cursor Property

The cursor property specifies the type of cursor to be displayed when you hover over an element. It has 36 possible values: 
```css
    .auto            { cursor: auto; }
    .default         { cursor: default; }
    .none            { cursor: none; }
    .context-menu    { cursor: context-menu; }
    .help            { cursor: help; }
    .pointer         { cursor: pointer; }
    .progress        { cursor: progress; }
    .wait            { cursor: wait; }
    .cell            { cursor: cell; }
    .crosshair       { cursor: crosshair; }
    .text            { cursor: text; }
    .vertical-text   { cursor: vertical-text; }
    .alias           { cursor: alias; }
    .copy            { cursor: copy; }
    .move            { cursor: move; }
    .no-drop         { cursor: no-drop; }
    .not-allowed     { cursor: not-allowed; }
    .all-scroll      { cursor: all-scroll; }
    .col-resize      { cursor: col-resize; }
    .row-resize      { cursor: row-resize; }
    .n-resize        { cursor: n-resize; }
    .e-resize        { cursor: e-resize; }
    .s-resize        { cursor: s-resize; }
    .w-resize        { cursor: w-resize; }
    .ns-resize       { cursor: ns-resize; }
    .ew-resize       { cursor: ew-resize; }
    .ne-resize       { cursor: ne-resize; }
    .nw-resize       { cursor: nw-resize; }
    .se-resize       { cursor: se-resize; }
    .sw-resize       { cursor: sw-resize; }
    .nesw-resize     { cursor: nesw-resize; }
    .nwse-resize     { cursor: nwse-resize; }
```

#### More Information:
Check the above cursor values in action: <a href='https://codepen.io/chriscoyier/pen/uCwfB' target='_blank' rel='nofollow'>codepen</a>

Mozilla Developer Network: <a href='https://developer.mozilla.org/en-US/docs/Web/CSS/cursor' target='_blank' rel='nofollow'>MDN</a>

Browser Support: <a href='http://caniuse.com/#search=cursor' target='_blank' rel='nofollow'>caniuse</a>
