---
title: Display Property
---
## Display Property

The display property specifies the type of box used for an HTML element. It has 20 possible keyword values. The commonly used ones are:

```css
    .none             {display: none;}
    .block            {display: block;}
    .inline-block     {display: inline-block;}
    .inline           {display: inline;}
    .flex             {display: flex;}
    .inline-flex      {display: inline-flex;}
    .inline-table     {display: inline-table;}
    .table            {display: table;}
    .inherit          {display: inherit;}
    .initial          {display: initial;}
```

#### More Information: 

Docs and full list of keyword values: <a href='https://developer.mozilla.org/en-US/docs/Web/CSS/display' target='_blank' rel='nofollow'>MDN</a>

Browser Support: <a href='http://caniuse.com/#search=display' target='_blank' rel='nofollow'>caniuse</a>

A Complete Guide to Flexbox: <a href='https://css-tricks.com/snippets/css/a-guide-to-flexbox/' target='_blank' rel='nofollow'>css-tricks</a>
