---
title: Font Property
---
## Font Property

The font CSS property is either a shorthand property for setting font-style, font-variant, font-weight, font-size, line-height, and font-family; or a way to set the element's font to a system font, using specific keywords.


### Examples

```css
/* Set the font size to 12px and the line height to 14px.
   Set the font family to sans-serif */
p { font: 12px/14px sans-serif }

/* Set the font size to 80% of the parent element
   or default value (if no parent element present).
   Set the font family to sans-serif */
p { font: 80% sans-serif }

/* Set the font weight to bold,
   the font-style to italic,
   the font size to large,
   and the font family to serif. */
p { font: bold italic large serif }

/* Use the same font as the status bar of the window */
p { font: status-bar }
```

#### More Information:

- [MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/font)



