---
title: Visibility Property
---
## Visibility Property

Visibility property can be used to control the visibility of any element. The default value is `visibility: visible;`


#### Possible values:

Visibility property can have 5 possible values.
1. `visible`: It is the default value which shows an element.
2. `hidden`: This value hides an element but preserves the layout or space occupied by the element.
3. `collapse`: This values is similar to hidden but is applicable for table rows or columns. It hides the row or column contents.
4. `initial`: This sets the property to its default value (visible).
5. `inherit`: This inherits the property value from that of its parent element.


#### Similarities and differences with other properties:

1. opacity: The difference between `visibility` property and `opacity` property, is opacity can be used for fading and element. `visibility: hidden;` and `opacity: 0;` has similar effect on an element.

2. display: The only difference between visibility: hidden; and display: none; is that, the latter removes the layout or space occupied by the element as well.


#### Browser compatibility:

This is a CSS2 property and is compatible with all the major browsers.


#### More Information:

[CSS Visibility - w3school](https://www.w3schools.com/cssref/pr_class_visibility.asp)

