---
title: White Space Property
---
## White Space Property
The white-space property sets how to display spaces between words. 

#### Syntax
white-space: normal | nowrap | pre | pre-line | pre-wrap | inherit

#### Example
```
p {
  white-space: nowrap;
}
```
#### Values
Normal:	Default value. Sequences of whitespace will collapse into a single whitespace. Text will wrap when necessary.
Nowrap:	Sequences of whitespace will collapse into a single whitespace. Text will never wrap to the next line.
Pre:	Whitespace is preserved by the browser. Text will only wrap on line breaks. Acts like the <pre> tag in HTML.
Pre-line:	Sequences of whitespace will collapse into a single whitespace. Text will wrap when necessary.
Pre-wrap:	Whitespace is preserved by the browser. Text will wrap when necessary.
Initial: Sets this property to its default value.
Inherit:	Inherits this property from its parent element.

#### Source:
<a href='https://www.w3schools.com/cssref/pr_text_white-space.asp' target='_blank' rel='nofollow'>White-space on W3schools</a>

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
<a href='https://developer.mozilla.org/en-US/docs/Web/CSS/white-space' target='_blank' rel='nofollow'>White-space on MDN</a>.
