---
title: Width Property
---
## Width Property

The width property sets the width of an element. It can be a keyword value, a length value (any value followed by a CSS unit like px or em), percentage, or it can be inherited by its parent. By default, its value is auto.

**Note**: The width property does not include padding, borders, or margins; it sets the width of the area inside the padding, border, and margin of the element!

```css
    .length-value {width: 100px;}
    .percentage {width: 50%;}
    .auto {width: auto;}
    .inherit {width: inherit;}
    .initial {width: initial;}
```

**Note**: The min-width and max-width properties override width.

#### More Information:

Docs: <a href='https://developer.mozilla.org/en-US/docs/Web/CSS/width' target='_blank' rel='nofollow'>MDN</a>

Browser Support: It's categorised under the 'well supported sub-set', so need not worry for browser support
