---
title: Text Align
---
## Text Align

This CSS property describes the horizontal alignment of inline content in its parent block element. `text-align` does not control the alignment of block elements, it affects only their inline content.

### CSS Syntax
`text-align: value;`

value : `left|right|center|justify|initial|inherit`

### Values:
The `text-align` property is specified as a single keyword chosen from the list of values below:  

`text-align: left;`  aligns the text to the left

`text-align: right;` aligns the text to the right

`text-align: center;` aligns the text to the center 

`text-align: justify;` makes the lines the same width 

`text-align: justify-all;` makes the lines the same width, including the last one  

`text-align: start;`  aligns the last line at the beginning of the line

`text-align: end;`  aligns the last line at the end of the line

`text-align: match-parent;`  calculate the values start and end to the parent's direction and replaced by the appropriate left or right value.

**Block Alignment Values (non-standard syntax)**:

`text-align: -moz-center;`

`text-align: -webkit-center;`

**Global Values**:

`text-align: inherit;` inherits from its parent element

`text-align: initial;` default value

`text-align: unset;` applies either the inherit or the initial value, depending on the default properties of the element

#### More Information:
- <a href='https://www.w3.org/TR/REC-CSS1/#text-align' target='_blank' rel='nofollow'>CSS1 Spec</a>
- <a href='https://www.w3.org/TR/CSS21/text.html#alignment-prop' target='_blank' rel='nofollow'>CSS2 Spec</a>
- <a href='https://www.w3.org/TR/css-text-3/#justification' target='_blank' rel='nofollow'>CSS3 Spec</a>
- <a href='https://developer.mozilla.org/en-US/docs/Web/CSS/text-align' target='_blank' rel='nofollow'>MDN Web Docs</a>
- <a href='https://css-tricks.com/almanac/properties/t/text-align/' target='_blank' rel='nofollow'>CSS Tricks</a>
