---
title: Vertical Align CSS  
---
## Vertical-Align

```vertical-align```is a CSS property used to vertically align an image.

For example, you can use ```vertical-align``` like this to align an image:
```
img {
  vertical-align: top;
}
```
These are the valid values for ```vertical-align```:
* ```baseline``` - This is the default value. It aligns the element to the baseline of the parent element
* ```length``` - This aligns the baseline of this element at a given length above or below the baseline of the parent. You can use pixels, em, %, etc.
* ```sub``` - This aligns the element as if it were the subscript of the parent element
* ```super``` - This aligns the element as if it were the superscript of the parent element
* ```top``` - This aligns the element so that the top of this element is in align with the top of the tallest element on the line
* ```bottom``` - This aligns the element so that the bottom of this element is in align with the bottom of the lowest element on the line
* ```middle``` - This aligns the element so that it is in the middle of the parent element
* ```text-top``` - This aligns the top of this element so that it is aligned with the top of the parent element's top
* ```text-bottom``` - This aligns the bottom of this element so that it is aligned with the bottom of the parent element's text

#### More Information:

* [CSS vertical-align](https://www.w3schools.com/cssref/pr_pos_vertical-align.asp)

* [CSS-Tricks vertical-align](https://css-tricks.com/almanac/properties/t/text-align/)
