---
title: W3 CSS Containers
---

## W3 CSS Containers
W3.css provides a container class which adds 16 pixels worth of left and right padding to any html element, and 0.01em of
top and bottom padding.
This makes it ideal for html containing elements such as ```<header>, <div>, <footer>, <section>```etc. But can also be used with great effect on elements like ```<img> and <p>.```

### Simple example
```html
<header class="w3-container">
  <h1>Header With W3 Container</h1>
</header>
```
```html
<header>
  <h1>Header Without W3 Container</h1>
</header>
```
Would produce the following result.

![Header img](https://github.com/OcelotDive/randomImages/blob/master/images/WithWithout.PNG)

### To use W3.Css Containers
Just add a regular stylesheet link to the head of your web page like so:
```html
<link rel="stylesheet" href="https://www.w3schools.com/w3css/4/w3.css">
```
or download the latest css file to your local machine [from here](https://www.w3schools.com/w3css/4/w3.css)



#### More Information on W3.Css Containers

* [W3schools.com](https://www.w3schools.com/w3css/w3css_containers.asp)


