---
title: D3
---
# D3: Data-Driven Documents

**Data-Driven Documents** (D3.js) is a JavaScript library for producing dynamic, interactive data visualizations in web browsers. **D3.js** API contains various methods which can be grouped into the following logical units - *Selections*, *Transitions*, *Arrays*, *Math*, *Color*, *Scales*, *SVG*, *Time*, *Layouts*, *Geography*, *Geometry*, *Behaviors*.

![D3.js Logo](https://i2.wp.com/pbiswas101.files.wordpress.com/2018/07/d3.jpg?w=312&h=161)

**D3.js** helps you visualize data by combining powerful visualization and interaction techniques with a data-driven approach to DOM manipulation. It also provides full capabilities of modern browsers by designing the right visual interface for your data.

**D3.js** version 1.0.0 was released back in 18 February 2011.

## Why D3.js?

For those already familiar with HTML and CSS, *D3* is quick to learn. Unlike **Processing**, **Raphaël**, or **Protovis**, *D3's* vocabulary of graphical marks comes directly from web standards: HTML, SVG, and CSS - https://d3js.org/

## Get Started
There are over [20,000 **D3.js** examples](https://github.com/d3/d3/wiki/Gallery) you could learn from, but you never know how approachable any given one will be! So, the question is - how do you build up your visualization from first principles? As you've probably seen, D3's API is massive, so lets call out a few of the utilities that will be particularly helpful early on:

- **[d3-scale](https://github.com/d3/d3-scale)**

![](https://i0.wp.com/pbiswas101.files.wordpress.com/2018/07/scale.png?w=400&h=100)

- **[d3-shape](https://github.com/d3/d3-shape)**

![](https://i0.wp.com/pbiswas101.files.wordpress.com/2018/07/shape.png?w=400&h=100)

- **[d3-selection](https://github.com/d3/d3-selection)**

![](https://i0.wp.com/pbiswas101.files.wordpress.com/2018/07/selection.gif?w=400&h=100)

- **[d3-collection](https://github.com/d3/d3-collection)**

![](https://i0.wp.com/pbiswas101.files.wordpress.com/2018/07/collection.png?w=400&h=100)

- **[d3-hierarchy](https://github.com/d3/d3-hierarchy)**

![](https://i2.wp.com/pbiswas101.files.wordpress.com/2018/07/hierarchy.png?w=400&h=100)

- **[d3-zoom](https://github.com/d3/d3-zoom)**

![](https://i1.wp.com/pbiswas101.files.wordpress.com/2018/07/zoom.gif?w=400&h=100)

- **[d3-force](https://github.com/d3/d3-force)**

![](https://i1.wp.com/pbiswas101.files.wordpress.com/2018/07/force.gif?w=400&h=100)

With just some basic knowledge of the latest HTML5 features such as SVG and Canvas, you can dive into a world where a library like **D3.js** can bring data to life!

### Contribution
-  https://github.com/d3/

### Resources
- [Wikipedia](https://en.wikipedia.org/wiki/D3.js)
- [Blockbuilder](http://blockbuilder.org/search)
- [D3 in Depth](https://d3indepth.com)
- [Learning D3](https://davidwalsh.name/learning-d3)
- [Motion Visualization with D3](https://omid.al/posts/2016-08-23-MocapVis-D3.html)
- [tutorialspoint](https://www.tutorialspoint.com/d3js/)
