---
title: Creative Commons Resources
---

## What are the Creative Commons?

Creative Commons licensing was created by the academic, attorney, and political activist Lawrence Lessig. The Creative Commons licensing options were created in a reaction to copyright law. Believing that the creative process involves building upon others ideas and content, copyright laws prevent this form of creative development. While copyright laws are needed, their effects extending to impact individuals and their creative development has been viewed as an unprecedented violation. The opposition to the copyright has been described as the copyleft. The Creative Commons are a cornerstone for the copyleft and supporting the public domain. In order to help bridge this issue of copyright law and amanture creative development, the Creative Commons were introduced to allow creators to apply a legal license allowing how their work can be used by others. The Creative Commons licensing options are easily understood by the layperson and can be created by answering only two questions:

1.) Allow adaptations of your work to be shared?

2.) Allow commercial uses of your work?

The Creative Commons license options can be made quickly at: - [Choose](https://creativecommons.org/choose/)

More descriptions about the various Creative Commons license options can be found here:- [Licenses](https://creativecommons.org/licenses/)


## Creative Commons Resources
	
Some people hate designing things, and that's okay. But one thing that they might hate _more_ is being sued for copyright infringement (for using content that someone else created without their expressed permission). 

Recently, I participated in a discussion on this topic and thought I'd share a handful of sites that I've turned to in the past for high quality, freely available content. If you are a designer, web developer, or just a blogger that needs some nice, shiny images, these will be right up your alley.

All of the following resources should [be licensed under Creative Commons](https://creativecommons.org/licenses/) (or at equally-worded license) for you to use at your own leisure:

- [Gratisography](http://gratisography.com/)
- [Unsplash](https://unsplash.com/)
- [Pixabay](https://pixabay.com)
- [Pexels](https://www.pexels.com)
- [Flickr (Creative Commons License)](https://www.flickr.com/search/?advanced=1&license=2%2C3%2C4%2C5%2C6%2C9)
- [Metropolitan Museum Collection](http://www.metmuseum.org/art/collection)
- [Life Magazine Archives](http://images.google.com/hosted/life)
- [New Old Stock](http://nos.twnsnd.co/)
- [Public Domain Archive](http://publicdomainarchive.com/)
- [Wikimedia Creative Commons](https://commons.wikimedia.org/wiki/Main_Page)

This is by no means an exhaustive list, but if you need some seriously high-resolution images to freely use - consider checking some of them out. 

> **NOTE:** If you are planning on using _any_ of these images for non-personal or commercial use, please double-check all specifics for that particular image (as some sites vary).

