---
title: Sketch
---
## Sketch

Sketch is a professional design application for the Mac that utilizes a vector-based workflow. The interface is clean and inviting for new users as well as being a familiar tool for users of Adobe Fireworks. Sketch has become a popular alternative tool to Adobe's Photoshop and Illustrator for users who do not need an over abundance of options for interface designs.

### Why Sketch?

* Easily reuse elements
* Prototyping
* Collaborate with others
* Lots of plugins
* Export files in multiple formats such as png, svg etc. Even 2x versions for retina displays are easily exportable
* Vast community
* Easily copy CSS attributes from design elements
* Exports style guide in easy to read HTML/CSS 

### Why Should I Switch To Sketch?

Sketch is designed to build digital products rather than editing photos and print graphics. Sketch's clean interface helps keep you organized when mocking up or building out your UI/UX designs. The art boards that Sketch uses enforces a pixel grid for precise designs. Exporting designs is simple and supports different device resolutions.

### Useful Plugins for Sketch

- [Sketch Plugin Manager - Keeps your plugins up-to-date and install plugins available on GitHub](https://mludowise.github.io/Sketch-Plugin-Manager/)
- [Zeplin - Generates and exports design assets and style guides](https://zeplin.io/)
- [Sketch IconFont - Helps you easily insert and manage icons from icon fonts](https://github.com/keremciu/sketch-iconfont)
- [Mirr.io - Preview prototypes in any browser in any device from Sketch](https://mirr.io/)
- [Craft - A suite of plugins by Invision that let you design with real data in mind.](https://www.invisionapp.com/craft)

#### More Information:

- [Sketch](https://www.sketchapp.com)
- [Sketch Documentation](https://www.sketchapp.com/docs/)
- [Learn Sketch](http://learnsketch.com/tutorials)
- [Sketch App Sources](https://www.sketchappsources.com/)
- [YouTube - Sketch crash course](https://www.youtube.com/playlist?list=PLWlUJU11tp4fEXI8deWhBQAHDv9R23WHB)
