---
title: Dark Patterns
---
## Dark Patterns

Dark Patterns are common patterns used to deceive the users of a website or web application.

Examples include:

* [**Bait and Switch**](https://darkpatterns.org/types-of-dark-pattern/bait-and-switch) – A user sets out to do one thing, but a different, undesirable thing happens instead.

* [**Disguised Ads**](https://darkpatterns.org/types-of-dark-pattern/disguised-ads) – Advertisements disguised as other kinds of content or navigation, in order to get users to click on them.

* [**Confirmshaming**](https://darkpatterns.org/types-of-dark-pattern/disguised-ads) – Confirmshaming is the act of guilting the user into opting in to something. The option to decline is worded in such a way as to shame the user into compliance.

* [**Forced Continuity**](https://darkpatterns.org/types-of-dark-pattern/forced-continuity) – Silently charging a user's credit card without warning at the end of a free trial.

* [**Friend Spam**](https://darkpatterns.org/types-of-dark-pattern/friend-spam) – A website or app asks for a user's email or social media permissions under the pretense it will be used for a desirable outcome (e.g. finding friends), but then spams all the user's contacts in a message that claims to be from that user.

* [**Hidden Costs**](https://darkpatterns.org/types-of-dark-pattern/hidden-costs) – User arrives at the last step of a checkout process, only to discover some unexpected charges appear, e.g. delivery charges, tax, etc. that were not disclosed prior to processing the user's payment.

* [**Misdirection**](https://darkpatterns.org/types-of-dark-pattern/misdirection) – The design purposefully focuses a user's attention on one thing in order to distract their attention from another.

* [**Price Comparison Prevention**](https://darkpatterns.org/types-of-dark-pattern/price-comparison-prevention) – An online retailer makes it hard for visitors to compare the price of an item with another item, so they cannot make an informed decision.

* [**Privacy Zuckering**](https://darkpatterns.org/types-of-dark-pattern/privacy-zuckering) – Users are tricked into publicly sharing more information about themselves than they really intended to. Named after Facebook CEO Mark Zuckerberg.

* [**Roach Motel**](https://darkpatterns.org/types-of-dark-pattern/roach-motel) – The design makes it very easy for users to get into a certain situation, but then makes it hard for them to get out of it (e.g. a subscription).

* [**Sneak Into Basket**](https://darkpatterns.org/types-of-dark-pattern/sneak-into-basket) – A user attempts to purchase something, but somewhere in the purchasing journey the site sneaks an additional item into their basket, often through the use of an opt-out radio button or checkbox on a prior page.

* [**Trick Questions**](https://darkpatterns.org/types-of-dark-pattern/trick-questions) – Users are made to respond to a question, which, when glanced upon quickly appears to ask one thing, but if read carefully, asks another thing entirely.


A catalog of Dark Patterns along with a continuously updated list of real-world examples is mainatained at [darkpatterns.org](https://darkpatterns.org).

