---
title: Developer Ethics
---
## Developer Ethics

Developer Ethics describes the field of ethics when applied to the behavior of software developers.

According to [The Internet Encyclopedia of Philosophy](http://www.iep.utm.edu/ethics/), the field of ethics (or moral philosophy) involves "systematizing, defending, and recommending concepts of right and wrong." 

Over the years, a number of organizations and individuals have attempted to codify developer ethics into a variety of oaths, pledges, and codes of conduct. 

Examples include:

* [**The International Standard for Professional Software Development and Ethical Responsibility**](http://seeri.etsu.edu/TheSECode.htm) by the IEEE-CS/ACM Joint Task Force on Software Engineering Ethics and Professional Practices

* [**The Ten Commandments of Computer Ethics**](http://computerethicsinstitute.org/publications/tencommandments.html) by the Computer Ethics Institute

* [**The Pledge of the Computing Professional**](http://pledge-of-the-computing-professional.org/home-page/the-oath)

* [**The Trustworthy Coder's Pledge**](https://medium.com/@BillSourour/the-trustworthy-coders-pledge-aa5ba046c5aa) by Bill Sourour

* [**The Programmer's Oath**](https://www.youtube.com/watch?v=36NgPu9OyRM&list=PLWKjhJtqVAbno-B4RmJHCDO0ZUKC2tpUQ) by "Uncle Bob" Martin

* [**The "Never Again" Pledge**](http://neveragain.tech)

* [**ACM Code of Ethics**](http://www.acm.org/about-acm/acm-code-of-ethics-and-professional-conduct)

Common themes appearing throughout these examples include a commitment to honesty, integrity, and fairness.

To date, since most software developers do not belong to – and are not governed by – any official order, guild, association, or society, no single, codified ethical standard has been widely adopted.

#### More Information:
* [Computer and Information Ethics](https://plato.stanford.edu/archives/win2014/entries/ethics-computer/) entry in the Stanford Encyclopedia of Philosophy.

* [Computer Ethics](https://en.wikipedia.org/wiki/Computer_ethics) entry in WikiPedia

* [CSE 302 - Professional Ethics for Computer Science](http://www3.cs.stonybrook.edu/~mueller/teaching/cse302/) – outline and study materials for a course given in the Computer Science department at Stony Brook University's College of Engineering and Applied Sciences.

* [A Very Short History of Computer Ethics](https://web.archive.org/web/20080418122849/http://www.southernct.edu/organizations/rccs/resources/research/introduction/bynum_shrt_hist.html) – article from the Summer 2000 issue of the American Philosophical Association’s Newsletter on Philosophy and Computing
