---
title: Resources
---

Where do you go if you have an ethical question as a developer? This page is a listing of resources you could use to help in a challenging situation.

1. Developer member associations

Member associations exist to promote the integrity of specific professions. Often, one of the services associations provide is in the area of ethics. 

One such association is the [Association for Computing Machinery](http://www.acm.org/about-acm/code-of-ethics). It provides a [code of ethics](http://ethics.acm.org/code-of-ethics) that you can reference. They also provide ongoing resources in the area of ethics for developers. 

Another source is the International Game Developers Association, which also has a [code of ethics](https://www.igda.org/?page=codeofethics).

2. Stay aware of what's happening in the world of development

Reading up on ethical challenges in the world of development will help you develop your own sense of "what would I do" before the need arises. 

Stay aware, and think through what you would do if faced with a similar situation. Practice your response in a challenging situation. One article that could help inform your opinion is [Should software developers have a code of ethics](https://www.cio.com/article/3156565/developer/should-software-developers-have-a-code-of-ethics.html) from cio.com.

3. Start conversations with your peers now

Ethics is highly influenced by office culture, so lead by example. Be that person in your organization who talks about ethics openly, and advocates for a more ethical culture when possible. Psychology Today has tips about [building an ethical culture](https://www.psychologytoday.com/blog/do-the-right-thing/201507/six-ways-create-culture-ethics-in-any-organization).

4. Don't give up

Don't become disheartened when a new ethical breach happens. Creating an ethical future for developers will take all of us. 

5. Know your "why"

Think about your users. Think about your community. Think about your family. Before you are in a challenging situation, know why you will do the right thing. 

6. Ask questions

It's okay not to know everything. If something makes you feel uneasy, ask. Chances are, someone either has the same question or has an answer for you.


