---
title: Build Automation
---
## Build Automation

<!-- The article goes here, in GitHub-flavored Markdown. Feel free to add YouTube videos, images, and CodePen/JSBin embeds  -->
Build is a version of software program. The term is used in reference to a program that is still in development. Build automation is the process of automating the creation of a software build and the associated processes including: Compiling computer source code into binary code, packaging binary code and running automated tests. Build automation software automates commonly performed tasks in the software development process.
Build is automated when the steps to creating a software are repeatable, require no direct human intervention and can be performed at any time with no information other than what is stored in the source code control repository. Build automation software often integrates with software testing products, version control systems, IDEs, bug tracking tools and PaaS providers.
Historically, build automation was accomplished through 'makefiles'. Today, there are two general categories of tools for build automation:

## - Build automation utility:
Its primary purpose is to generate build artifacts through activities like compiling and linking source code.

## - Build automation servers:
They are general web based tools that execute build automation utilities on a scheduled or trigger basis; continuous integration server is a type of build automation server.

There are three subcategories to Build automation:
- Continuous Integration
- Configuration management
- other Build automation.

Below is a list of some notable tool associated with automating build processes:
- GNU make
- make
- mk
- Apache Ant
- BitBake
- Boot
- Ninja
- Qt Build system
- Rake
- Stack
- Psake
- MSBuild
- Visual Build
- Tweaker
- Waf
- [Jenkins](https://jenkins.io/)
- TeamCity and others.

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->

<a href="https://www.agilealliance.org/glossary/automated-build/#q=~(filters~(postType~(~'page~'post~'aa_book~'aa_event_session~'aa_glossary~'aa_organizations~'aa_research_paper~'aa_video)~tags~(~'automated*20build))~searchTerm~'~sort~false~sortDirection~'asc~page~1)">What is Build Automation?</a> <br>
<a href="https://en.m.wikipedia.org/wiki/List_of_build_automation_software">List of Build Automation Software</a> <br>
<a href="https://en.m.wikipedia.org/wiki/Build_automation">Build Automation - Wikipedia</a> <br>
<a href="https://www.webopedia.com/TERM/B/build.html">Webopedia</a> <br>
<a href="https://www.g2crowd.com/categories/build-automation">Build Automation</a>
