---
title: Markdown
---
## Markdown
Markdown is a lightweight markup language with plain text formatting syntax. It is designed so that it can be converted to HTML and many other formats using a tool by the same name. Markdown is often used to format README files, for writing messages in online discussion forums, and to create rich text using a plain text editor.  You can also write Markdown in your text editor (like Sublime Text or Visual Studio Code).
Markdown is gaining in visibility and popularity through the emergence of streamlined, "distraction-free" text editors.

## Example
You can run the following code in Visual Studio Code by saving it using a .md extension and pressing Ctrl+Shift+V to see the preview.

```
Heading
=======

## Sub-heading

Paragraphs are separated
by a blank line.

Two spaces at the end of a line  
produces a line break.

Text attributes _italic_, 
**bold**, `monospace`.

Horizontal rule:

---

Bullet list:

  * apples
  * oranges
  * pears

Numbered list:

  1. wash
  2. rinse
  3. repeat

A [link][example].

  [example]: http://example.com

![Image](Image_icon.png "icon")

> Markdown uses email-style > characters for blockquoting.

Inline <abbr title="Hypertext Markup Language">HTML</abbr> is supported.

```

## More Information:
A cheatsheet is one of the easiest way to learn Markdown. Check out <a href='https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet' target='_blank' rel='nofollow'>this popular cheatsheet</a>.

You can also check out this online tutorial: <a href='https://www.markdowntutorial.com' target='_blank' rel='nofollow'>Markdown Tutorial</a>

Love learning by videos? Check out <a href='https://www.youtube.com/watch?v=HndN6P9ke6U' target='_blank' rel='nofollow'>this Youtube video</a>

The GitHub <a href='https://guides.github.com/features/mastering-markdown/' target='_blank'>Mastering Markdown</a> guide provides an introduction to Markdown, gives examples, and notes some additional features in the version used on GitHub.
