---
title: Source Code Editors
---
## Source code editors

Source code editors are the programs that allow for code creation and  
editing. Any text editor can be used to write code. But dedicated code  
editors offer many useful features, including: text completion,  
markup coloring, and tabs/panes for side-by-side editing. These features can  
be useful even to new users who don't know their way around all of the  
advanced options.

### Choosing an editor

There are many, many editors available to download or use  
online, both paid and free. They offer many of the same core-features, but  
each have their own subtleties. Further research may help find the one that's  
right for you. The following editors are all cross-platform and  
free to use or evaluate.
  
  
### Sublime text

![Sublime Text Icon](https://logo.clearbit.com/sublimetext.com)

Sublime Text is a very popular editor that has been around <a href='https://www.sublimetext.com/blog/articles/one-point-oh' target='_blank' rel='nofollow'>since 2008</a>. There are many options and <a href='https://packagecontrol.io/' target='_blank' rel='nofollow'>extensions</a> available, and a lot of <a href='http://stackoverflow.com/search?q=sublime+text' target='_blank' rel='nofollow'>help available</a> online to help <a href='http://www.websightdesigns.com/wiki/Setting_up_Sublime_Text_3' target='_blank' rel='nofollow'>set it up</a>. (The license for continued use costs $80(personal use)\. However, Sublime Text is free to download and evaluate, with a nag-screen pop-up.)

<a href='https://www.sublimetext.com/' target='_blank' rel='nofollow'>sublimetext.com</a>

![Sublime Text Screenshot](//discourse-user-assets.s3.amazonaws.com/original/2X/6/63f774c31a7b1a439bcef9d11e95463b6998310e.png)
  
  
### Brackets

![Brackets Icon](https://logo.clearbit.com/brackets.io)

Brackets is a relatively new open-source editor by Adobe. It is very user friendly, especially for people who aren't used to command-line interfaces or JSON-style settings/preferences. Extensions and themes are quick and easy to find and install through the Extension Manager.

<a href='http://brackets.io/' target='_blank' rel='nofollow'>brackets.io</a>

![Brackets Screenshot](//discourse-user-assets.s3.amazonaws.com/original/2X/2/2f395a58d24ed551ed8440a10ae640777f1143b6.png)
  
  
### Atom

![Atom Icon](https://i.imgur.com/ToWQjHO.png)

Atom is an <a href='https://github.com/atom/atom' target='_blank' rel='nofollow'>open source</a> editor, developed by <a href='https://github.com/' target='_blank' rel='nofollow'>GitHub</a>. Like Sublime Text, Atom is quite popular. It is very configurable ("hackable", as they say) but advanced features may be overwhelming to new users. There is also plenty of <a href='http://readwrite.com/2014/05/20/github-atom-5-tips-getting-started-tutorial-corey-johnson/' target='_blank' rel='nofollow'>helpful</a> <a href='http://flight-manual.atom.io/' target='_blank' rel='nofollow'>documentation</a> <a href='http://stackoverflow.com/search?q=atom' target='_blank' rel='nofollow'>available</a> online.

<a href='https://atom.io/' target='_blank' rel='nofollow'>atom.io</a>

![Atom Screenshot](//discourse-user-assets.s3.amazonaws.com/original/2X/8/8016e7c0937e8ce6fcb6104c9aee0026443912f5.png)


### Visual Studio Code

![Visual Studio Code Icon](https://i.imgur.com/eULdyep.png)

Visual Studio Code (a.k.a vsc or vscode) is a very popular, open source editor, developed by <a href="https://www.microsoft.com" target="_blank" rel="nofollow">Microsoft</a> and fast becoming widely used by developers of all languages. Like Atom and Sublime, Visual Studio Code has a wide range of <a href="https://marketplace.visualstudio.com/VSCode" target="_blank" rel="nofollow">extensions</a> and <a href="https://marketplace.visualstudio.com/search?target=VSCode&category=Themes&sortBy=Downloads" target="_blank" rel="nofollow">themes</a> available to help customise and perfect your experience using it, however VSC is highly configurable "out-the-box". There is also a very active development team behind VSCode, with new features and bug fixes being added by the Visual Studio Code team <a href="https://code.visualstudio.com/updates" target="_blank" rel="nofollow">every month</a>.

<a href='https://code.visualstudio.com/' target='_blank' rel='nofollow'>code.visualstudio.com</a>

### Notepad++

![Notepad++ Icon](https://upload.wikimedia.org/wikipedia/commons/0/0f/Notepad%2B%2B_Logo.png)

Notepad++ is a free, open source code editor, that runs in the Microsoft Windows Environment. It was developed in 2003, by Dan Ho. It is written in <a href='www.cplusplus.com' target='_blank' rel='nofollow'>C++</a> (the name comes from that). Notepad++ supports tabbed editing, which allows working with multiple open files in a single window, and can be used as a plain text editor.

<a href='https://notepad-plus-plus.org' target='_blank' rel='nofollow'>notepad-plus-plus.org</a>

### VIM

![VIM Icon](https://www.vim.org/images/vim_header.gif)

VIM is an advanced text editor open source tool which is also considered to be an IDE in its way. This tool allows managing your text editing activities with vim editors and UNIX System which can be used on-premise or online. It is written in C. Vim is a highly configurable text editor built to enable efficient text editing. It is an improved version of the vi editor distributed with most UNIX systems.

<a href='https://www.vim.org/' target='_blank' rel='nofollow'>vim.org</a>

