---
title: Code documentation
---
## Code Documentation

Code Documentation is the tool developers use to make the purpose of their code clear. It's also called Commenting, but it's about more than just the comments you include with your code. It includes how you space and indent your code, name your variables, and give titles to various sections so it is easy to read and understand.

Code Documentation lets anyone (from newbie to seasoned expert) quickly get comfortable with the customs of the particular module, functions etc for a particular programming language. For example, if you pass your code to an absolute beginner, they should be able to follow along. Here is an article from Harry Roberts at CSS Wizardy Ltd. (https://csswizardry.com/2013/01/mindbemding-getting-your-head-round-bem-syntax/) about structuring class names in CSS. This is just one example of good code documentation.

An excellent example of the value in good code documentation is the debugging process. The first step in debugging is to read the code documentation, right? But good code documentation goes beyond a readme file or header comments. Code Documentation means commenting every function, loop or declaration. It's having, and following, a variable naming process. And it means spacing and indenting your code so it's easy to read.

There is always the danger of over-commenting your code, too. Here is a video from Brian Voong where he discusses this danger and how to avoid it by using good naming conventions. (https://www.youtube.com/watch?v=2-KBQsTo8AY)

It is extremely important to make a habit out of commenting your functions, loops, and declarations and treating comments as part of the source code, just as regular code should be.

Many developers have probably learned that it is much harder to go back through your code and comment it after you finish. It's always a good idea to label and comment your code as you go, so that you don't forget or mix up what certain variables or functions do.

Think of Code documentation as a history textbook. It allows current developers to keep tabs on their progress, as well as to educate future developers. Use it not only as a learning tool, but also as a reminder. As George Santayana once said, "Those who do not read history are doomed to repeat it!"

Have an interest in learning more and building your coding skills? Have a look at FreeCodeCamp.org. They have thousands of hours of free instruction that include how to comment and organize your code so it is well documented.

![An example of commenting in the real world](https://cdn-images-1.medium.com/max/1620/1*Pyxsc7Uixbitv5myywaA_Q.jpeg)

Even though the code itself should always be self explanatory, it is often good to have a document along with the code files that describes it into more detail. The idea of such a document is not only to cover the technical parts so that contributors are able to add or change the code but also for people wanting to use the program. For that reason, it is for example good to have a guide on how to use the created program and some examples along with it. Documents become especially important for bigger projects since it can be a lot more time consuming and complicated to understand a program by just reading its code compared to an explanatory document. 
If the program uses already existing material such as libraries or is based on some other projects, it is always a good idea to mention those in the document since it is part of the foundation.


#### More Information

* [Medium Article about Code Documentation](https://medium.com/@andrewgoldis/how-to-document-source-code-responsibly-2b2f303aa525)

* [Code Tuts top 15 Best Practices](https://code.tutsplus.com/tutorials/top-15-best-practices-for-writing-super-readable-code--net-8118)

* [Medium Article "The Good, The Bad, The Ugly"](https://medium.freecodecamp.org/code-comments-the-good-the-bad-and-the-ugly-be9cc65fbf83)

* [Medium Article about "Writing great documentation"](https://medium.com/@episod/writing-great-documentation-44d90367115a)
