---
title: Game Development
---

## Game Development

Game Development is the art of creating games and describes the design, development and release of a game. It may involve concept generation, design, build, test and release. While you create a game, it is important to think about the game mechanics, rewards, player engagement and level design.

A game developer could be a programmer, a sound designer, an artist, a designer or many other roles available in the industry.

Game Development can be undertaken by a large Game Development Studio or by a single individual. The game can be as small or large as you like. You can call it a 'game' as long as the player can interact with content and manipulate the game's elements.

To get involved in the Game Development process, you do not need to write code. Artists may create and design assets, while a Developer might focus on programming a health bar. A Tester may get involved to verify that the game works as expected.

![What first games looked like](https://i.ytimg.com/vi/ePc12V6F0ws/maxresdefault.jpg "What first games looked like")

To resolve problems that game frameworks had, tools like libGDX and OpenGL were developed. They helped make game development a lot faster and easier, providing many pre-made functions and features. However, understanding the framework and entry into the industry were still difficult for those coming from non-programmer backgrounds, a common case in the game development scene.

![3D map editor made with OpenGL](https://i.ytimg.com/vi/E0laTeycpB4/maxresdefault.jpg "3D map editor made with OpenGL")

That was when game engines like Construct, Game Maker, Unity and Unreal were developed. Generally, an engine has everything that a framework had, but with a more friendly approach by using a graphic user interface (GUI) and helping with the graphic development of the game.

In some cases, like Game Maker and Construct, the amount of pre-made functions are so big that people with no previous programming skills could build a game from scratch, really expanding the scene and making game development accessible for almost anyone.

## What is Game Design?

Game design is about creating opportunities for players to make meaningful decisions that affect the outcome of the game.

The following list illustrates the definition of game design in the context of specific games.

- Command & Conquer: placing troops effectively
- Mass Effect: distributing earned points to character stats
- Advance Wars: choosing which piece to move
- Battlefield 2: aiming and firing your weapon
- Rock Band: pressing the right buttons at the right time
- Monopoly: purchasing properties and utilities.

The action or decision in each example changes the outcome of the game because each decision has consequences. Buying property in Monopoly has the immediate effect of costing you money, but you will get to charge the other players rent as the game continues. The decisions are meaningful because each choice has consequences in the game.
Types of Designers

Game development is a collection of design disciplines. In the beginning of the video game industry, game designers often designed the program, the sound, and the graphics for an entire game. Richard Garriott, for instance, created everything for the first Ultima game and its predecessor, Akalabeth. He was not unique. Only a few famous designers, like Sierra’s Roberta Williams, who created the King’s Quest series and other well-known adventure games, had no programming experience.

Today, games are generally developed collaboratively, with specialists in the following roles:

**Game Designer**
- Game designers are responsible for creating all or part of gameplay. For instance, they may create the combat system, mission design, the way missions are tracked, the player’s inventory, or even something like crowd behavior in a fighting game. 

**Lead Designer**
- Lead designers oversee all other designers, review or test their work, and make sure the vision of the game is realized. The lead designer may be responsible for creating the vision. More often, a group of designers, the team as a whole, or even the publishers create the vision for the game. 

**World Design**
- World designers are art-based and focus on creating environments and objects in the game. For board games, world design would include graphics for the board and cards.

**System Design**
- System designers create the mechanics of the game and the goals and rules for gameplay.

**Content Design or Writing**
- Content designers or writers create the narrative of the game. The narrative can be in the form of mission details, NPC (non-player character) text, or story. Content designers are incredibly important in MMOs (massively multiplayer online game), with their persistent world and constant need for new quests, NPCs, and narrative. Content designers need to have strong writing skills.

**Level Design**
- Level designers create full levels within virtual worlds. They are responsible for creating the flow of the level as well as the gameplay that takes place within that level. Most products have multiple level designers as well as a lead level designer. Often, level designers work on 3D worlds for FPS (first-person shooter) or RTS (real-time strategy) games. However, level designers also work on all types of projects, from platform games to RPGs (role-playing games). Each style of gameplay requires different kinds of expertise. 

**Technical Designer**
- Technical designers write the scripts that drive some component of gameplay. As the name implies, technical designers must have technical aptitude in addition to their overall game design ability. The scripting language the designer uses varies from product to product, and may be proprietary (created in-house and not available outside the company) or a commercial product. To create scripts, the designer may code a basic mission, enemy behavior, or even the way in which NPCs talk with or behave around the player character. 

**User Interface**
- User interface, or UI, designers create game interfaces and define the ways a player interacts with the game world. In other fields, UI designers are often called “usability experts.” UI designers are becoming increasingly important as the video game industry seeks to expand its audience beyond the traditional gamer. In many cases, the lead game designer or lead artist takes on the role of designing the game’s interface.

**Interaction Design**
- Interaction designers have a similar role to UI designers. Both designers are involved with designing a game’s interface. Interaction designers focus more on making sure the interface is intuitive and responsive to the user. 

### Game Engines

![Unity development screen](http://paulbourke.net/stereographics/Unitystereo/textureplanes.jpg "Unity development screen")

Many developers choose to develop a game using a Game Development Engine.

Game Engines can make the process of creating a game much easier and enable developers to reuse lots of functionality. It also takes care of rendering for 2D and 3D Graphics, physics and collision detection, sound, scripting and much more.

Some Game Engines have a very steep learning curve such as CryEngine or Unreal Engine. Yet, other tools are very accessible to beginners and some do not even need you to be able to write code to create your game, e.g. Construct 2.

The Unity Game Engine ranges somewhere in the middle, while it is beginner friendly, some popular and commercial games have been built using Unity (e.g. Overcooked, Superhot).

The BuildBox game engine is basically for developing hypercasual games.

### Typical Game Engines

- [CryEngine](https://www.cryengine.com/)
- [Unreal Engine](https://www.unrealengine.com/en-US/what-is-unreal-engine-4)
- [Unity](https://unity3d.com/)
- [Game Maker](https://www.yoyogames.com/gamemaker)
- [Construct](https://www.scirra.com/)
- [Twine](http://twinery.org/)
- [Source](https://developer.valvesoftware.com/wiki/SDK_Docs)
- [Frostbite](https://www.ea.com/frostbite)
- [Buildbox](https://www.buildbox.com/)
- [Godot Engine](https://godotengine.org/)
- [Phaser](https://phaser.io)

### More Information

* [Awesome-List of GameDev resources](https://github.com/Kavex/GameDev-Resources)
* [Game Programming Books](http://www.fromdev.com/2013/07/game-development-books.html)
* [libGDX Framework](https://libgdx.badlogicgames.com/)
* [OpenGL Framework](https://www.opengl.org/)
