---
title: MDA Methodology (mechanics, design, and aesthetics)
---

The purpose of MDA methodology is to give developers, scholars, and researchers a common foundation they can use to understand, discuss, analyze, and research games and game development. [2]


MDA methodology uses the relationship between the game designer and the player to provide a framework for the game development process. Figure 1 visualizes the relationship between game designers and players. Designers make the game and players consume the game.
An illustration of two figures on either side of a box representing a game. The figure on the left is the designer, and an arrow points from the designer to the game. The figure on the right is the player, and an arrow points from the player to the game.


Often, the term “fun” is used to talk about games and commercial success. An important factor for games is to evoke an aesthetic response in players. The way a player consumes a game is different than the way users consume other media. MDA breaks down the player’s consumption into three components: rules, system behavior, and fun. A game’s rules determine the system behavior, and the system behavior creates fun, or an enjoyable game experience. If you just focus on consumption, the relationship between the designer and player is represented the illustration in Figure 2.
An illustration of two figures on either side a row of three boxes. From left to right, the boxes represent rules, system behavior, and fun. The figure on the left next to the rules box is the designer, and the figure on the right next to the fun box is the player.


The three aspects of consumption—rules, system behavior, and fun—translate directly into design terms: Rules become mechanics, system behavior becomes dynamics, and fun becomes aesthetics. [3] You now have the three components of MDA methodology: mechanics, dynamics, and aesthetics. The terms are defines below.

    Mechanics are the rules and concepts that define the game system.
    Dynamics are the rules when the system is running.
    Aesthetics are the feelings the game dynamics create in the player. [4]

To use mechanics, dynamics, and aesthetics in context, consider an example of a FPS game. The mechanics are the rules whch say you will take damage if you get hit with a bullet. Dynamics happen when a character in the game shoots at you. When you realize you’re being shot at, you experience the aesthetics of competition, survival, and fear.

## Eight Types of Fun

The way a game’s aesthetic impacts players’ emotions are often interpreted as “fun.” As a designer, it is helpful to break “fun” down into more specific experiences. According to MDA methodology inventor and game designer Marc LeBlanc, there are eight types of fun in games:

    Sensation: The game is pleasurable to the senses.
    Fantasy: The game explores imaginary worlds of make-believe.
    Narrative: The game tells a story.
    Challenge: The game is an obstacle course.
    Fellowship: The game provides a social framework.
    Discovery: The game explores uncharted territory.
    Expression: The game is an outlet for self-discovery.
    Submission: The game is used to pass time. [5]

Many games incorporate several types of fun. For example, charades uses fellowship, expression, and challenge. [6] Fellowship comes from the player’s team, expression is from acting out the prompt, and the prompts are the challenge. Final Fantasy uses fantasy, narrative, expression, discovery, challenge, and submission. Titan Fall uses challenge, sensation, and fantasy.

When you design your game, think about which types of fun support your game core.

## MDA Components as Models

Mechanics, dynamics, and aesthetics can be used as models or lenses of interpretation. The following topics will look at mechanics, dynamics, and aesthetics as individual models.

As you read about each model, keep in mind the following properties that indicate useful and reliable models:

    Formal: Models should be well defined.
    Abstract: Models should be widely applicable.
    Proven: Models should be known to work.

Models can be used independently, or they interact with each other. When you analyze a game, it is helpful to use more than one model, because each will focus on different aspects of the game.

## Aesthetic Models

Aesthetic models encourage designers to think about the player experience. One of the most common mistakes novice designers make is failing to consider the player experience before designing the specifics of the game. If you identify the type of experience you want a player to have, it can help you select mechanics and dynamics that support this aesthetic model. Remember that all aspects of your game must support your game core, including your aesthetic model.

Aesthetics can determine the success or failure of a game. For example, flight simulator games caught on in the 1990s, and developers made them more and more realistic. However, it turned out that players didn’t necessarily want all of the buttons and screens of a realistic helicopter—the experience of flying was more important. Remember that the player’s experience is critical to a game’s success. You will use the iterative process to design your game in order to make sure player feedback is integrated into the game.

## Designing for Aesthetic Models

As a designer, you can select an aesthetic model that supports your game core, and use it to help shape the elements of the game. For example, if your game core is about surviving a zombie apocalypse, you can decide to make the player feel fear. To make the player feel fear, you will need to develop fear aesthetics.

To develop any type of aesthetic, think about what causes the feeling you’re trying to develop. For a fear aesthetic, you can incorporate the following elements that cause fear:

    uncertainty
    loss of physical senses
    sudden sounds
    being hunted or stalked
    being trapped
    losing something you value
    not getting something you want
    loss of life.

Keep in mind that the ability to reload a game, start over, or play something else has taken some of the impact out of the loss of life element. For example, recovering from death in World of Warcraft is as simple as resurrecting your character and finding your body.

Next, think about ways you can incorporate the elements that cause the aesthetic you chose into the game mechanics. For the fear example, loss of physical senses is an element of fear. You can incorporate this into the game in a variety of ways:

    Give enemies the ability to turn off and on lights.
    Use trip wires.
    Use blinding lights.
    Create invisible or transparent enemies.
    Design a level with many corners.
    Give enemies the ability to blind players temporarily.

You should also consider how the player’s character could respond to or interact with the elements of the fear aesthetic. For example, you could give the character tools like night vision or a flashlight. These tools can be given or taken away based on the game’s rules and goals. As you select and develop each element of your aesthetic model, your game will begin to take shape.

## Dynamic Models

Dynamic models are used to predict gameplay by identifying feedback systems. [7] You can use feedback systems to determine if a change or action in gameplay has a positive or negative effect on the game.

For example, if you study the dynamics of buying property and paying rent in Monopoly, you will find that it’s very difficult for players who are not in the lead to catch up and win the game. [8] The winning players make more money in each turn, which allows them to buy more property. Players with less money have to pay the richer players, which makes them less able to afford property and earn income.

Once you identify this dynamic, you can consider ways to make the game more equitable. [9] You can find a way to help losing players catch up or create more obstacles for winning players.

Dynamic models and aesthetic models can be related. You might want a game to make a player feel tension and drama, but testing the game reveals that the game needs more tension. You can add a game mechanic like a time limit. A time limit creates the dynamic of time pressure—the player has to act quickly to complete the task, or face consequences. The time pressure dynamic increases the tension in the game and creates a dramatic aesthetic.
Mechanic Models

Remember that game mechanics are the rules of the game, and dynamics are the game’s systems in action. Game mechanics of card games include shuffling and placing bets, which lead to dynamics like bluffing. [10] In the dramatic game mentioned above, a time limit is the mechanic and the pressure created by the time limit is the dynamic.

Since game dynamics are created from the mechanics, adjusting the mechanics also adjusts the dynamics. If you recall the Monopoly example from dynamic modes, it’s very difficult for players who are behind to catch up and possibly win. If you change a game mechanic like adding a tax on the wealthiest player, it shifts the game dynamics to make it possible for losing players to catch up to the winners. [11]
