---
title: Meaningful Play
---

## Meaningful Play

The goal of game design is to create meaningful play. When people care about a game and its outcome, they become emotionally invested and the game is meaningful to them. Games are synthetic experiences—they take place in a constructed environment, and consequences in the game don’t affect the outside world. The challenge for game designers is to make games in synthetic environment meaningful to the player.

People care about a game when something is at stake. There are a variety of stakes, including:

    your team or friend
    your character or avatar
    your reputation or ego.

When a game has stakes, players become emotionally invested in the outcome. Players want to see their team in Counter-Strike succeed, trash-talk their friends when they beat them in Guitar Hero, and take pleasure in being in the top 10 on a leader board. It’s a sign of gaming prestige to say you have a level-60 character in World of Warcraft. It feels good to beat Minesweeper, Hearts, and Solitaire.

## Defining Meaningful Play

There are two ways to define meaningful play, descriptive and evaluative.

## Descriptive Meaningful Play

Rules of Play defines meaningful play in a descriptive sense as a process where “a player takes action within the designed system of a game and the system responds to the action.” [12] The game creates meaning through “the relationship between player action and system outcome.” [13] You can think of this system as cause-and-effect.

## Evaluative Meaningful Play

The Rules of Play definition for meaningful play in an evaluative sense requires some unpacking. Evaluative meaningful play “occurs when the relationships between actions and outcomes in a game are both discernable and integrated into the larger context of the game.” [14]

    A discernable outcome means that a player understands the immediate outcome of an action. [15] For example, the player’s action is rolling a pair of dice in a board game. The outcome of the action is that the player advances the number of spaces on the dice.

    An integrated outcome means that the actions players take are “woven into the game system as a whole” and make sense in the narrative. [16] For example, Monopoly simulates real estate transactions. Each part of the game supports the simulation: the money looks like currency; there is a bank to make change, and a system for exchanging money and property. The more integrated a game is, the more closely it simulates an aspect of the real world.

For games to be meaningful in an evaluative sense, a player must understand the cause-and-effect of their actions, and the player’s actions must relate to the gameplay.

## Provide Clear and Meaningful Goals

Video game designer and producer Shigeru Miyamoto’s games are known for their intuitive nature. The Nintendo Wii follows the same design philosophy of intuition and simplicity. The basic function of its controller is intuitive to many people who aren’t gamers because it’s so similar to a television remote.

Unfortunately, not every game or game system is so easy to use. While playing games, you may have entered an environment with your avatar and realized you don’t know what your goal is, or how to achieve it. Or, you may have finished a quest and did not know how to move forward in the game. You may have been given a quest that you don’t care about because it seems to have nothing to do with the game or its narrative. In these cases, the game failed to provide clear and meaningful goals.

A goal is clear if players understand what they’re supposed to do and how they need to do it. That doesn’t necessarily mean giving everything away. In fact, giving players all the answers would remove the struggle referred to in Costikyan’s definition of games from Unit 1.

Instead of giving the player all the answers, clear goals get the player started toward a goal. For instance, imagine that you were assigned a quest to find an ancient key. In the game you have already met an old seer and been to an antiquities shop. Either the seer or the shop could have the key. The game created clear goals by telling you what to find (the key), and placing the key in a logical part of the game world. Unclear or irrelevant goals frustrate players.

A goal is meaningful if players actually care about its completion. The game Playboy: The Mansion provides an example. If players purchased computers for their journalists, the players could then assign journalists to “research.” Research makes better journalists who, in turn, write better articles. Better articles lead to better magazine issues and to better sales. While it was a valid goal, players seldom pursued it. Players did not complete this goal because they could just fire and hire journalists any time they wanted to without any penalty. Why spend time improving a journalist when hiring a new and better one is more efficient? The goal and its reward lacked meaning.

The most meaningful goals have incentives to engage players in the game. In the game Psychonauts, designer Tim Shafer provides a strong narrative motivation for the character. In the beginning of the game the protagonist, your avatar, is at a summer camp. His fellow campers, including his best friend, disappear. As players explore the game and complete goals, puzzles and additional parts of the game unlock. This rewards the player for completing goals.

Goals can also lose their meaning if they are too repetitive, and don’t contribute enough to the game narrative. This is a common problem in MMOs. For example, if an NPC requests you to “go get five saber teeth and bring them back,” after you’ve already completed several delivery-style quests, you will probably be reluctant. Fulfilling the delivery may improve your avatar slightly, but the goal itself has little effect on the game world, so it lacks meaning.

If players are assigned too many of the same types of quests, they become bored. Goals are stronger and provide more immersion if they motivate both the player and the character in the game world

## The Right Amount of Information

Players must be able to understand the state of the game world.

The more trouble they have to go through to find something out, the more frustrated they will be and the less meaningful the play will be. Games can give players too much or too little information. The HUD (heads-up display—the main interface of the game) may present so much information that the player can’t make sense of it all, or it may not present enough information, so the player misses out on some options.

![Dead Space](https://vignette.wikia.nocookie.net/deadspace/images/5/5b/Dead_Space_2011-01-05_02-18-08-82.jpg/revision/latest?cb=20111107164346 "Dead Space")

The game Dead Space provides the right amount of information, and it’s displayed successfully. Instead of using menus or a HUD to show a character’s health, Dead Space indicates a player’s health through the yellow bar on the character’s backpack, illustrated in Figure 4.
A screenshot of the video game Dead Space, showing two characters fighting, a zombie and the protagonist, whose back is facing the camera, showing a glowing yellow bar on its back, indicating its health level.
Fig. 4: Integrating Information into the Game Display (Eurogamer.net)

![Beyond Good and Evil](https://gpstatic.com/acache/18/41/1/uk/s6-f4fe5c6fdc78e2873f22ed4f0f196df2.jpg "Beyond Good and Evil")

In Ubisoft’s Beyond Good & Evil, the HUD displays are very minimal. As the player completes quests, the town fills up with villagers that begin to protest the government. In addition to providing meaningful goals and relevant gameplay, the game information is presented well. Figures 5 and 6 are both screenshots from Beyond Good & Evil, at different points in the game. Information is only presented when it is needed. In Figure 5, the only HUD element is the envelope in the bottom right-hand corner. A line of text under the image of the envelope tells players how to read the message. Since it is the only element in the HUD display, it attracts the player’s attention. With the brief instructions, the player also knows what to do next (open the letter) and how to do it (press the arrow key).
A screenshot of the video game Beyond Good & Evil, showing the female protagonist standing in an empty futuristic village with her helper character. A blue glowing envelope symbol is in the bottom right-hand corner, with a line of text under it telling the player to press the left arroe button to read the message. There is no other text or symbols on the screen.
Fig. 5: A Minimal and Instructive HUD Display (SinhVienIT.Net)

![Beyond Good and Evil](https://ubistatic19-a.akamaihd.net/ubicomstatic/en-US/global/media/bge_hd_city_revolution_158407.jpg "Beyond Good and Evil")


Figure 6 is also from Beyond Good & Evil. This screenshot shows the protagonist and helper character in a different location in the game. They are on a street walking past protesters. Now that the characters are no longer alone, there could be risks, and the HUD has changed to reflect the new circumstance. The envelope symbol is gone, and the HUD now shows the protagonist and helper character’s health stats. The health stats are very easy to read: health is indicated by glowing or non-glowing hearts, and the character’s head is displayed next to their health bar. The protagonist’s active items are also displayed next to her health bar. In Figure 6, she has blue data disks.
A screenshot of the video game Beyond Good & Evil, showing the female protagonist down a street with the helper character, past protesters holding signs. The HUD display shows glowing hearts in a row to communicate level of health and the protagonist’s active items are shown next to her health. The envelope symbol from Figure 5 is gone.
Fig. 6: HUD Display Changes with Circumstances (SinhVienIT.Net)

Figures 4 – 6 show how to display the right amount of information, and how to make sure that information does not intrude on the game play. In both games, nothing extra is shown on the screen, and the information is easy to understand.
Relevant Gameplay

“Because it’s cool!” is often heard along the road to bad game design. When added features, quests, or gameplay mechanics don’t provide meaning, or when they are integrated into the game world without creating meaningful play, the point is lost.

Meaningless game mechanics frustrate to players.

Consider tutorials or cutscenes that cannot be skipped. The first time through, the sequence is meaningful because the player learns about the game world. However, after the first viewing, the tutorials or cutscenes lose their informative and entertainment value.

When you analyze a game’s features, ask yourself: “How does this affect the main task of the player in the game? Is it meaningful?”  

