---
title: Unity
---

# Unity
## Game Development with Unity

Unity is a cross-platform game engine developed by Unity Technologies. It is primarily used to develop video games and simulations for computers, consoles and mobile devices.
First announced only for OS X, at Apple's Worldwide Developers Conference in 2005, it has since been extended to target 27 platforms.

## Overview
Unity is an all-purpose game engine that supports 2D and 3D graphics, drag and drop functionality and scripting through [C#](https://guide.freecodecamp.org/csharp).

Unity is particularly popular for mobile game development and much of their focus is on mobile platforms. Unity3D's 2D pipeline is a more recent addition to the engine, and is less mature than the 3D pipeline. Despite this Unity is an adequate platform for developing 2D games even when compared to other dedicated 2D engines, particularly if you plan to release the game across multiple mobile devices due to its ease of access of building for different platforms.

Unity is also a good choice for VR development, although VR is a very small market at the moment, but growing. The mobile and PSVR markets are the largest in VR, and Unity is already well positioned to port games to many platforms such as PS4 and PC, or many different mobile markets. Unity also allows the development of AR Content and has training sessions with both VR and AR articles.

The engine targets the following graphics APIs: Direct3D on Windows and Xbox One; OpenGL on Linux, macOS, and Windows; OpenGL ES on Android and iOS; WebGL on the web; and proprietary APIs on the video game consoles.

Additionally, Unity supports the low-level APIs Metal on iOS and macOS and Vulkan on Android, Linux, and Windows, as well as Direct3D 12 on Windows and Xbox One. Within 2D games, Unity allows importation of sprites and an advanced 2D world renderer.

For 3D games, Unity allows specification of texture compression and resolution settings for each platform that the game engine supports, and provides support for bump mapping, reflection mapping, parallax mapping, screen space ambient occlusion (SSAO), dynamic shadows using shadow maps, render-to-texture and full-screen post-processing effects.

## Services and Platforms Supported

Unity also offers services to developers, these are: Unity Ads, Unity Analytics, Unity Certification, Unity Cloud Build, Unity Everyplay, Unity IAP, Unity Multiplayer, Unity Performance Reporting and Unity Collaborate. Besides this, Unity has an asset store where the developer community can download and upload both commercial and free third party resources such as textures, models, plugins, editor extensions and even entire game examples.

Unity is notable for its ability to target games for multiple platforms. The currently supported platforms are Android, Android TV, Facebook Gameroom, Fire OS, Gear VR, Google Cardboard, Google Daydream, HTC Vive, iOS, Linux, macOS, Microsoft HoloLens, Nintendo 3DS family, Nintendo Switch, Oculus Rift, Oculus Go, Oculus Quest, PlayStation 4, PlayStation Vita, PlayStation VR, Samsung Smart TV, Tizen, tvOS, WebGL, Wii U, Windows, Windows Phone, Windows Store, and Xbox One.

Unity is the default software development kit (SDK) for Nintendo's Wii U video game console platform, with a free copy included by Nintendo with each Wii U developer license.
Unity Technologies calls this bundling of a third-party SDK an "industry first".

## Interface

![Unity Interface](https://github.com/pawelszpiczakowski/PublicStuff/raw/master/unityInterface.png)

In picture above, you will notice five section:

1) Section 1. <b>Scene View</b>: This is where you will be creating level for your game, scene or 3D project. All of your Game Objects will be placed and manipulated right here.
2) Section 2. <b>Game View</b>: This is where you will see your results, how your level or scene looks like. You need to have a Camera on the scene to see how it looks like. Sometimes it's called Camera View.
3) Section 3. <b>Hierarchy</b>: This window will display all Game Objects placed directly on the scene. Basically everything that you see in Game View, needs to be listed here. This will include non-visual and visual game objects.
4) Section 4. <b>Project</b>: This is your project window. Basically it show what's inside Assets folder on your disk. Everything from Game Objects, Scripts, Textures, Folders, Models, Audio, Video and etc... will be accessible from this window.
5) Section 5. <b>Inspector</b>: This panel will display different attributes and properties of selected Game Objects. Depending on the selection, the appropriate attributes and components will be listed.

Apart from the above listed sections, more sections can be brought into the Unity editor whenever required. Some notable ones are listed below:

1. <b>Light</b>: This section allows us to modify the overall light settings of the project/scene.
2. <b>Animator</b>: This is the section where we can set up animation states for a Game Object and how it transitions from one animation to next.
3. <b>Animation</b>: Here we can create animation sequences for our Game Objects within the Unity engine.
4. <b>Profiler</b>: This section allows us to profile our game. Here we can see the performance, memory usage, fps and other characteristics of our game and which function, script, object, etc. is causing how much effect on the quality of our game.
5. <b>Asset Store</b>: If we are logged into our Unity account in the editor, we can directly access the Unity Asset Store and download and import the required assets into our project.

Unity Editor interface is heavily customisable as each section in window can be resized and docked anywhere in the editor as per our requirements. It is also possible in Unity to create custom windows and editor tools via script.

##  Noteworthy Games:
* Angry Birds II
* Assassin’s Creed: Identity
* Battlestar Galactica Online
* Beat Saber
* Cuphead
* Dragon Quest VIII (iOS and Android versions)
* Hearthstone: Heroes of Warcraft
* Inside
* Pillars of Eternity I & II
* Torment: Tides of Numenera
* Temple Run Trilogy
* Tesla Effect: A Tex Murphy Adventure
* Wasteland 2

## History

Two other programming languages were supported: Boo, which was deprecated with the release of Unity 5 and UnityScript which was deprecated in August 2017 after the release of Unity 2017.1.

Unity formerly supported 7 other platforms including its own Unity Web Player.

Unity Web Player was a browser plugin that was supported in Windows and OS X only, which has been deprecated in favor of WebGL.

Unity is the engine used by Rust, Kerbal Space Program, and Cuphead.

## Marketing
On December 16, 2013, Unity Technologies Japan revealed new screenshots for an official mascot character named Unity-chan (ユニティちゃん Yuniti-chan), real name Kohaku Ōtori (大鳥 こはく Ōtori Kohaku) (voiced by Asuka Kakumoto), with exhibit of the character in Comic Market 85 event in the Tokyo Big Sight between December 29 to the 31st, where themed goods would be distributed and her voice actress would be present at the event. The character's associated game data were to be released in spring 2014.[26][27][28] The character was designed by Unity Technologies Japan designer "ntny" as an open-source heroine character.[29] The company allows the use of Unity-chan and related characters in secondary projects under certain licenses.[30] For example, Unity-chan appears as a playable character in Runbow.[31] The popularity of the character also led to her appearance in VOCALOID adaptions, including her own sound library for VOCALOID4 and a special adaption of VOCALOID designed to work with the Unity Engine 5.0 version called Unity with VOCALOID.

#### More Information:

* [Unity's Official Website](https://unity3d.com/)
* [Wikipedia](https://en.wikipedia.org/wiki/Unity_(game_engine))
* [Official Unity Tutorials](https://unity3d.com/learn)
