---
title: Unreal Engine
---

## Game Development with Unreal Engine

Unreal Engine is a cross-platform game engine developed by Epic Games. The Unreal Engine was initially developed for the 1998 FPS title Unreal, but has been subsequently used for many thousands of commercial and non-commercial titles. The most recent version of the engine, Unreal Engine 4, targets PC, PlayStation 4, Xbox One, Mac OS X, iOS, Android, many VR systems, Linux, SteamOS, and HTML5, and the editor can run on Windows, OS X and Linux.

Uscript is the engine's native scripting language, used for creating game code and gameplay events before the release of Unreal Engine 4, and was designed for high level programming.  The script was written and programmed by Tim Sweeney, also the creator of another scripting language, ZZT-oop.

Since 2015 the Unreal Engine has been free to use, with Epic charging a 5% royalty on sales of titles produced using the engine. Epic make the majority of their codebase freely available via their GitHub, although source for closed platforms such as the PlayStation 4 and Xbox One is only available for registered platform developers.

### Unreal Versions
Unreal has gone through 4 major revisions. Although some code is common between releases, each major version is a separate engine and projects cannot be moved between them. Within each major engine release, there are multiple minor versions.

  * Unreal Engine 1
  Released in 1998 and targeted Windows PC, Linux, Mac, PlayStation 2 and Dreamcast. The engine was written in C++, and easily moddable using the Unreal Script language.

  * Unreal Engine 2
  Released in 2002 and targeted Windows PC, Linux, Mac, PlayStation 2 and Xbox. The engine was written in C++, utilized the Unreal Script language.

  * Unreal Engine 3
  Released in 2004 and targeted Windows PC, Linux, Mac, iOS, PlayStation 3 and Xbox 360.  Development is split between Unreal Script and C++, with an additional visual scripting interface called Kismet.

  * Unreal Engine 4
  Released in 2015 and targets PC, PlayStation 4, Xbox One, Mac OS X, iOS, Android, many VR systems, Linux, SteamOS, and HTML5, and the editor can run on Windows, OS X and Linux. Unreal Script has been removed and replaced with dynamically reloaded C++ modules, and a more advanced visual scripting interface called Blueprints. Since the release of version 4.20, Unreal Engine has been taking big steps towards mobile gaming and currently is a great tool for developing high-end titles on Android, iOS platforms.
  
### Popular Games made in Unreal
- Batman: Arkham City
- Mass Effect
- Bioshock
- BioShock 2
- Borderlands
- Gears of War
- Fortnite
- Spec Ops: The Line
- Disney's Brother Bear
- Clive Barker's Undying
- Deus Ex- Spec Ops: The Line
- Enslaved: Odyssey to the West
- Adventure Pinball: Forgotten Island



#### More Information:

- <a href='https://www.unrealengine.com/' target='_blank' rel='nofollow'>www.UnrealEngine.com</a>  
- <a href='https://github.com/EpicGames' target='_blank' rel='nofollow'>www.EpicGames.com</a>
- <a href='https://academy.unrealengine.com/' target='_blank' rel='nofollow'>https://academy.unrealengine.com/</a>  
- <a href='https://docs.unrealengine.com/en-us/Programming/Development/CodingStandard' target='_blank' rel='nofollow'>Coding Standards</a> 

