---
title: Difference between Git and GitHub
---
## Difference between Git and GitHub

Git and GitHub are two different things. [Git](https://git-scm.com/) is the [version control system](https://en.wikipedia.org/wiki/Version_control), while [GitHub](https://github.com/) is an online service for hosting Git repos and helping people collaborate on writing software. However, the two are often confused due to their similar names, and because of the fact that GitHub builds on top of Git. Also, many websites and articles don't make the distinction between them clear enough.

![Git is not GitHub](https://i.imgur.com/EkjwJdr.png)

### Git

Git is the distributed version control system responsible for keeping track of changes to content – usually source code files.

For more info, there is a [complete article about Git itself](https://guide.freecodecamp.org/git).

### GitHub

GitHub is a company that provides Git repository hosting. This means that they provide a turnkey solution to host Git repositories on their servers. It can be useful to keep a backup of your repositories as well (Git only tracks the changes made to your files over time, and the repo still needs to be backed up), and GitHub is a centralized place to keep and share your code with others.

More than just a Git repository hosting service, GitHub is a [software forge](https://en.wikipedia.org/wiki/Forge_(software)). This means that it also provides an [issue tracker](https://en.wikipedia.org/wiki/Issue_tracking_system), tools for [code review](https://en.wikipedia.org/wiki/Code_review), and many features for collaborating with other people and creating software.

GitHub isn't the only one to provide this kind of service. One of its major competitors is [GitLab](https://gitlab.com). For more on this, look at the [article about Git hosting](https://guide.freecodecamp.org/git/git-hosting).
