---
title: GraphQL
---

# GraphQL
Developed by Facebook and launched in 2015, GraphQL is an API standard defined by its use of a declarative request that returns only the data the client requested, in the shape they desire. Unlike traditional REST APIs, GraphQL allows the client side of an application to ask for the exact pieces of data it requires in a readable way.

An alternative to the fixed endpoints of REST, its flexible approach makes aggregating data from multiple sources simpler, analytics are more refined and minimising the data fetched puts less pressure on slower networks, which speeds up responses for users

GraphQL schemas are often coupled with frameworks such as [Relay](https://facebook.github.io/relay/) or [Apollo](https://www.apollographql.com/) to make these requests from the client. GraphQL powers how [GatsbyJS](https://www.gatsbyjs.org) fetches data.

## Installation
From the command line run:

```sh
npm init
npm install graphql --save
```

## Queries
<!-- This section is a stub.  Consider contributing by forking this repository and submitting a Pull Request with your changes! -->

## Mutations
<!-- This section is a stub.  Consider contributing by forking this repository and submitting a Pull Request with your changes! -->

## Resolvers
<!-- This section is a stub.  Consider contributing by forking this repository and submitting a Pull Request with your changes! -->

## Schemas
<!-- This section is a stub.  Consider contributing by forking this repository and submitting a Pull Request with your changes! -->

## Additional Resources
- For tutorials and more information check out the GraphQL official site: [Getting Started With GraphQL.js](https://graphql.org/graphql-js/)
- [GraphQL Site and Documentation](https://graphql.org/)
- [How to GraphQL Tutorial](https://www.howtographql.com/)
